## ---- include = FALSE, message = FALSE----------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("gm_vignette"), "true")
)

## ----message = FALSE----------------------------------------------------------
library(gm)

## -----------------------------------------------------------------------------
m <- Music()

## -----------------------------------------------------------------------------
m <- m +
  # add a 4/4 time signature
  Meter(4, 4) +
  # add a musical line of a C5 whole note
  Line(pitches = list("C5"), durations = list("whole"))

## -----------------------------------------------------------------------------
m

## -----------------------------------------------------------------------------
show(m, to = c("score", "audio"))

## -----------------------------------------------------------------------------
m <- m + Tempo(120)
show(m)

## -----------------------------------------------------------------------------
m <- m + Line(
  pitches = list("C3", "G3"),
  durations = list("half", "half")
)

show(m)

## -----------------------------------------------------------------------------
m <- m + Line(
  pitches = list(c("E4", "G4"), c("D4", "F4"), c("F4", "A4"), c("E4", "G4")),
  durations = list("quarter", "quarter", "quarter", "quarter"),
  as = "voice",
  to = 1
)

show(m)

## -----------------------------------------------------------------------------
l <- Line(
  pitches = list("C4", c("E4", "G4"), NA),
  durations = list("quarter", "quarter", "quarter")
)

## -----------------------------------------------------------------------------
l

## -----------------------------------------------------------------------------
m <- Music() + Meter(4, 4) + l
show(m)

## -----------------------------------------------------------------------------
pitches <- c(60, 62, 64, 65)

## ---- echo = FALSE------------------------------------------------------------
m <- Music() + Meter(4, 4) + Line(as.list(pitches), rep(list(1), 4))
show(m)

## -----------------------------------------------------------------------------
pitches + 7

## ---- echo = FALSE------------------------------------------------------------
m <- Music() + Meter(4, 4) + Line(as.list(pitches + 7), rep(list(1), 4))
show(m)

## ---- echo = FALSE------------------------------------------------------------
m <- Music() + Meter(3, 4) + Line(list("C#5", "D-5", "B##4"), list(1, 1, 1))
show(m)

## -----------------------------------------------------------------------------
l <- Line(list(73, 73), list(2, 2))
m <- Music() + Meter(2, 4) + Key(7, bar = 1) + Key(-7, bar = 2) + l
show(m)

## ---- echo = FALSE, results = "asis"------------------------------------------
for (i in 1:length(gm:::duration_types)) {
  cat(paste0(
    '- `"', (gm:::duration_types)[i], '"` or ',
    '`"', (gm:::duration_type_abbrs)[i], '"`\n\n'
  ))
}

## -----------------------------------------------------------------------------
m <- Music() + Meter(6, 4) + Line(list(NA, NA, NA), list("w", "q", "32"))
show(m)

## -----------------------------------------------------------------------------
l <- Line(rep(list(NA), 5), list("q", "q.", "q..", "q...", "q...."))
m <- Music() + Meter(9, 4) + l
show(m)

## -----------------------------------------------------------------------------
l <- Line(rep(list(NA), 3), list("q/3", "q/3", "q/3"))
m <- Music() + Meter(1, 4) + l
show(m)

## ---- echo = FALSE------------------------------------------------------------
t1 <- tuplet("q", Tupler(3, take = "q"))
t2 <- tuplet("q", Tupler(3, take = "8"))

m <- Music() + Meter(1, 4) + Line(list(NA, NA), list(t1, t2))
show(m)

## -----------------------------------------------------------------------------
t <- tuplet("quarter", Tupler(3, unit = "eighth", take = "eighth"))

## -----------------------------------------------------------------------------
t

## -----------------------------------------------------------------------------
tuplet("quarter", Tupler(3, unit = "eighth", take = "quarter"))

## -----------------------------------------------------------------------------
t <- tuplet("quarter", Tupler(3, unit = "quarter", take = "quarter"))
t

## -----------------------------------------------------------------------------
m <- Music() + Meter(1, 4) + Line(list(NA, NA, NA), list(t, t, t))
show(m)

## -----------------------------------------------------------------------------
t <- tuplet(
  "half",
  Tupler(3, unit = "quarter", take = "half"),
  Tupler(3, unit = "quarter", take = "quarter")
)

t

## -----------------------------------------------------------------------------
l <- Line(rep(list(NA), 4), list(t, t, t, tuplet("half/3")))
m <- Music() + Meter(2, 4) + l
show(m)

## ---- error = TRUE------------------------------------------------------------
# try to create a `Line` object which consists of only one tuplet
Line(list(NA), list("q/3"))

## ---- error = TRUE------------------------------------------------------------
l <- Line(list(NA, NA, NA), list("h/3", "h/3", "h/3"))
m <- Music() + Meter(1, 4) + l
show(m)

## -----------------------------------------------------------------------------
l <- Line(
  pitches = list(c("C5", "E5"), c("C5", "E5"), c("C5", "E5"), c("C5", "E5")),
  durations = list("quarter", "quarter", "quarter", "quarter"),
  tie = list(c(1, 1), c(2, 2), 3)
)

m <- Music() + Meter(4, 4) + l
show(m)

## -----------------------------------------------------------------------------
m <- Music() + Meter(1, 4) + Line(list("C5"), list(4))
show(m)

## -----------------------------------------------------------------------------
l <- Line(list("C5", "D5", "E5"), list(1, 1, 1))
m <- Music() + Meter(4, 4) + l
show(m)

## -----------------------------------------------------------------------------
l <- Line(list("C5", "D5", "E5"), list(1, 1, 1), bar = 3, offset = 2)
m <- Music() + Meter(4, 4) + l
show(m)

## -----------------------------------------------------------------------------
l1 <- Line(rep(list("E5"), 8), rep(list(0.5), 8), name = "a")
m <- Music() + Meter(4, 4) + l1
show(m)

## -----------------------------------------------------------------------------
l2 <- Line(list("C4", "G4"), list(2, 2), name = "b")
show(m + l2)

## -----------------------------------------------------------------------------
l2 <- Line(list("C4", "G4"), list(2, 2), name = "b", to = "a", after = FALSE)
m <- m + l2
show(m)

## -----------------------------------------------------------------------------
l3 <- Line(
  pitches = list("A4", "B4", "C5"),
  durations = rep(list("w/3"), 3),
  name = "c",
  to = "a",
  as = "voice"
)

m <- m + l3
show(m)

## -----------------------------------------------------------------------------
l4 <- Line(list("E3"), list(4), to = "b", as = "staff", name = "d")
m <- m + l4
show(m)

## -----------------------------------------------------------------------------
m

## -----------------------------------------------------------------------------
Meter(number = 3, unit = 4)

## -----------------------------------------------------------------------------
Music() + Meter(3, 4)

## -----------------------------------------------------------------------------
m <- Music() + Meter(3, 4) + Meter(1, 8, bar = 2)
m

## -----------------------------------------------------------------------------
m <- m + Line(list("G4", "A4"), list(3, 0.5))
show(m)

## -----------------------------------------------------------------------------
m <- Music() +
  Meter(4, 4, actual_number = 1, actual_unit = 4) +
  Meter(4, 4, bar = 2, invisible = TRUE)

m

l <- Line(list("A4", "B4", "C5", "D5", "E5"), rep(list(1), 5))
show(m + l)

## -----------------------------------------------------------------------------
for (key in -7:7) {
  print(Key(key))
}

## -----------------------------------------------------------------------------
m <- Music() + Meter(1, 4) + Key(-7) + Key(0, bar = 2) + Key(7, bar = 3)
m

l <- Line(list(NA, NA, NA), list(1, 1, 1))
show(m + l)

## -----------------------------------------------------------------------------
m <- Music() + Meter(4, 4) +
  Line(list("E5"), list(4)) +
  Line(list("G4", "A4"), list(2, 2), to = 1, as = "staff") +
  Line(list("C4"), list(4)) +
  Line(list("C3", "D3"), list(2, 2), to = 3, as = "staff")

show(m)

## -----------------------------------------------------------------------------
m <- m + Key(-2, to = 1)
show(m)

## -----------------------------------------------------------------------------
m <- m + Key(2, to = 4, scope = "staff")
show(m)

## -----------------------------------------------------------------------------
Clef("G")

Clef("G", line = 1)

Clef("G", octave = 1)

Clef("G", octave = -1)

Clef("F")

Clef("F", line = 3)

Clef("F", line = 5)

Clef("F", octave = 1)

Clef("F", octave = -1)

Clef("C")

Clef("C", line = 1)

Clef("C", line = 2)

Clef("C", line = 4)

Clef("C", line = 5)

## -----------------------------------------------------------------------------
l <- Line(list("B3", "C4", "D4"), list(3, 3, 3))
m <- Music() + Meter(3, 4) + l
show(m)

## -----------------------------------------------------------------------------
m <- m + Clef("G", to = 1)
show(m)

## -----------------------------------------------------------------------------
m <- m + Clef("F", to = 1, bar = 2)
show(m)

## -----------------------------------------------------------------------------
m <- m + Clef("G", octave = -1, to = 1, bar = 3, offset = 2)
show(m)

## -----------------------------------------------------------------------------
Tempo(tempo = 240)

## -----------------------------------------------------------------------------
Tempo(tempo = 240, unit = "half")

## -----------------------------------------------------------------------------
m <- Music() +
  Meter(4, 4) +
  Line(as.list(70:77), rep(list(1), 8)) +
  Tempo(60) +
  Tempo(240, unit = "half.", bar = 1, offset = 2.5)

show(m, to = c("score", "audio"))

## -----------------------------------------------------------------------------
pitches <- as.list(c(64, 65, 69, 71, 72, 76))
durations <- rep(list(1), length(pitches))

m <- Music() + Meter(4, 4) + Tempo(120)

for (i in 0:8) {
  m <- m + Line(pitches, durations, offset = 0.5 * i)
}

show(m, to = c("score", "audio"))

