% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootCI.R
\name{CombineResampledLists}
\alias{CombineResampledLists}
\title{When running BootGlmm in distributed fashion,
combines output}
\usage{
CombineResampledLists(..., return_combined_list = FALSE)
}
\arguments{
\item{...}{Say our output from BootGlmm from three separate computers is
output_list1,
output_list2,
output_list3
We can run: CombineResampledLists(output_list1, output_list2, output_list3)
OR: create a list of lists:
output_list_list <- list(output_list1, output_list2, output_list3)
and then: CombineResampledLists(output_list_list)}

\item{return_combined_list}{Logical, default FALSE. TRUE if you want the combined
list of lists, FALSE for just the output from BootCI applied to it.}
}
\value{
Returns the same output as BootCI by default,
  or the combined list (as if you had just run BootGlmm once with
  all resamples) if return_combined_list = TRUE
}
\description{
If you run BootGlmm on e.g. a grid of computers,
set return_coefs_instead = TRUE for each.
Then enter them all here. Either just list them out,
or put them into one list and enter them.
}
\examples{
\donttest{
  data(test_data)
  library(glmmTMB)
  ## where subj is some RE
  test_model <- glmmTMB(y ~ x_var1 + (1 | subj), data = test_data, family = binomial)
  output_list1 <- BootGlmm(test_model, 99, base_data = test_data, return_coefs_instead = TRUE)
  output_list2 <- BootGlmm(test_model, 100, base_data = test_data, return_coefs_instead = TRUE)
  output_list3 <- BootGlmm(test_model, 100, base_data = test_data, return_coefs_instead = TRUE)
  CombineResampledLists(output_list1, output_list2, output_list3)

  num_blocks = 10
  num_total_resamples = 299
  reg_list <- list()
  for(i in 1:num_blocks){
      if(i < num_blocks){
          block_resamples = floor((num_total_resamples + 1)/num_blocks)
      } else {
          block_resamples = floor((num_total_resamples + 1)/num_blocks - 1)
      }
      reg_list[[i]] = BootGlmm(test_model,
                               resamples = block_resamples,
                               base_data = test_data,
                               return_coefs_instead = TRUE,
                               num_cores = 1, ## increase for parallel
                               suppress_loading_bar = TRUE)
  }
  boot_ci1 <- CombineResampledLists(reg_list)
  full_list <- CombineResampledLists(reg_list, return_combined_list = TRUE)
  boot_ci2 <- BootCI(full_list$base_coef_se, full_list$resampled_coef_se)
  identical(boot_ci1, boot_ci2)
}
}
