% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{override_summary}
\alias{override_summary}
\title{Overrides the Generalized Linear Models summary methods}
\usage{
override_summary()
}
\description{
This function overrides the \code{\link[stats:summary.glm]{summary.glm}}
and \code{\link[stats:summary.glm]{summary.negbin}} S3 methods
by the \code{\link{summarylr}} function in the calling environment.
}
\details{
Although some minor compatibility issues may exist when calling this function in the global environment,
most scripts should work with it. Indeed \code{\link{summarylr}} behaves like \code{\link[stats:summary.glm]{summary.glm}}
but adds a $extra field containing P-value info. The first letter of the field name ('e') is unique, avoiding problems
with scripts that access fields with short names (e.g. model$x for model$xlevels).
}
\examples{
model = glm(family="binomial", cbind(50,30) ~ 1)
override_summary()
summary(model) # Additional 'LRT P-value' column
}
\seealso{
Other Extended GLM summary functions: 
\code{\link{print.summary.glmglrt}()},
\code{\link{summarylr}()}
}
\concept{Extended GLM summary functions}
