% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.gllvm.R
\name{residuals.gllvm}
\alias{residuals.gllvm}
\title{Dunn-Smyth residuals for gllvm model}
\usage{
\method{residuals}{gllvm}(object, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{...}{not used.}
}
\value{
\item{residuals }{matrix of residuals}
 \item{linpred }{matrix of linear predictors}
}
\description{
Calculates Dunn-Smyth residuals for gllvm model.
}
\details{
Computes Dunn-Smyth residuals (randomized quantile residuals, Dunn and Smyth, 1996) for gllvm model.
For the observation \eqn{Y_{ij}} Dunn-Smyth residuals are defined as

\deqn{r_{ij}=\Phi^{-1}(u_{ij}F_{ij}(y_{ij})  + (1-u_{ij})F_{ij}^-(y_{ij})),}

where \eqn{\Phi(.)} and \eqn{F_{ij}(.)} are the cumulative probability functions of the standard normal
distribution, \eqn{F_{ij}^-(y))} is the limit as \eqn{F_{ij}(y)} is approached from the negative side, and \eqn{u_{ij}} has been
generated at random from the standard uniform distribution.
}
\examples{
# Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
# Fit gllvm model
fit <- gllvm(y = y, family = poisson())
# residuals
res <- residuals(fit)

}
\references{
Dunn, P. K., and Smyth, G. K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics, 5, 236-244.

Hui, F. K. C., Taskinen, S., Pledger, S., Foster, S. D., and Warton, D. I. (2015).  Model-based approaches to unconstrained ordination. Methods in Ecology and Evolution, 6:399-411.
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>
}
