% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getf0.R
\name{f0.control}
\alias{f0.control}
\title{Control arguments for f0 update algorithm}
\usage{
f0.control(eps = 1e-10, maxiter = 1000, maxhalf = 20, maxlogstep = 2)
}
\arguments{
\item{eps}{Convergence threshold. The update has converged when the relative
change in log-likelihood between iterations is less than \code{eps}.
absolute change is less than \code{thesh}.}

\item{maxiter}{Maximum number of iterations allowed.}

\item{maxhalf}{Maximum number of half steps allowed per iteration if
log-likelihood does not improve between iterations.}

\item{maxlogstep}{Maximum optimization step size allowed on the
\code{log(f0)} scale.}
}
\value{
Object of S3 class "f0Control", which is a list of control arguments.
}
\description{
This function returns control arguments for the \eqn{f_0} update algorithm.
Each argument has a default value, which will be used unless a different
value is provided by the user.
}
