% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{get_probabilities_from_gips}
\alias{get_probabilities_from_gips}
\title{Extract probabilities for \code{gips} object optimized with \code{return_probabilities = TRUE}}
\usage{
get_probabilities_from_gips(g)
}
\arguments{
\item{g}{An object of class "gips";
a result of a \code{find_MAP(return_probabilities = TRUE)}.}
}
\value{
Returns a numeric vector, calculated values of probabilities.
Names contains permutations this probability represent.
For \code{gips} object optimized with \code{find_MAP(return_probabilities = FALSE)},
returns a \code{NULL} object.
}
\description{
After the \code{gips} object was optimized with \code{\link[=find_MAP]{find_MAP()}} function with
\code{return_probabilities = TRUE}, then those calculated probabilities
can be extracted with this function.
}
\examples{
g <- gips(matrix(c(1, 0.5, 0.5, 1.3), nrow = 2), 13, was_mean_estimated = FALSE)
g_map <- find_MAP(g,
  optimizer = "BF", show_progress_bar = FALSE,
  return_probabilities = TRUE, save_all_perms = TRUE
)

get_probabilities_from_gips(g_map)
}
\seealso{
\itemize{
\item \code{\link[=find_MAP]{find_MAP()}} - The \code{get_probabilities_from_gips()}
is called on the output of
\code{find_MAP(return_probabilities = TRUE, save_all_perms = TRUE)}.
\item \code{vignette("Optimizers", package = "gips")} or its
\href{https://przechoj.github.io/gips/articles/Optimizers.html}{pkgdown page}) -
A place to learn more about the available optimizers.
}
}
