% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggside-ggproto.r, R/sideFacet--utils.R,
%   R/sideFacet-Grid.R, R/sideFacet-Null.R, R/sideFacet-Wrap.R
\docType{data}
\name{ggside-ggproto-facets}
\alias{ggside-ggproto-facets}
\alias{as_ggsideFacet}
\alias{check_scales_collapse}
\alias{sidePanelLayout}
\alias{map_data_ggside}
\alias{FacetSideGrid}
\alias{FacetSideNull}
\alias{FacetSideWrap}
\title{Extending base ggproto classes for ggside}
\usage{
as_ggsideFacet(facet, ggside)

check_scales_collapse(data, params)

sidePanelLayout(layout, ggside)

map_data_ggside(data, layout, params)
}
\arguments{
\item{facet}{Facet ggproto Object to replace}

\item{ggside}{ggside object to update}

\item{data}{data passed through ggproto object}

\item{params}{parameters passed through ggproto object}

\item{layout}{layout computed by inherited ggproto Facet compute_layout method}
}
\value{
ggproto object that can be added to a ggplot object
}
\description{
S3 class that converts old Facet into one that
is compatible with ggside. Can also update
ggside on the object. Typically, the new ggproto
will inherit from the object being replaced.

\code{check_scales_collapse} is a helper function that
is meant to be called after the inherited Facet's
compute_layout method

\code{sidePanelLayout} is a helper function that
is meant to be called after the inherited Facet's
compute_layout method and after \code{check_scales_collapse}

\code{map_data_ggside} is the mapping function
used to replace all map_data method on \link{FacetSideNull},
\link{FacetSideGrid}, and \link{FacetSideWrap}. It is exported
for conveniences of extensibility.
}
\section{Extended Facets}{


The following is a list \link{ggplot2} facets that are
available to use by ggside base.

\itemize{
\item \link[ggplot2]{FacetNull} -> FacetSideNull
\item \link[ggplot2]{FacetGrid} -> FacetSideGrid
\item \link[ggplot2]{FacetWrap} -> FacetSideWrap
}
}

\keyword{datasets}
