% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_shape.R
\name{scale_edge_shape}
\alias{scale_edge_shape}
\alias{scale_edge_shape}
\alias{scale_edge_shape_discrete}
\alias{scale_edge_shape_continuous}
\alias{scale_edge_shape_manual}
\alias{scale_edge_shape_identity}
\title{Edge shape scales}
\usage{
scale_edge_shape(..., solid = TRUE)

scale_edge_shape_discrete(..., solid = TRUE)

scale_edge_shape_continuous(...)

scale_edge_shape_manual(..., values)

scale_edge_shape_identity(..., guide = "none")
}
\arguments{
\item{...}{common discrete scale parameters: \code{name}, \code{breaks},
\code{labels}, \code{na.value}, \code{limits} and \code{guide}.  See
\code{\link{discrete_scale}} for more details}

\item{solid}{Should the shapes be solid, \code{TRUE}, or hollow,
\code{FALSE}?}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Guide to use for this scale.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new shape scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2]{scale_shape}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_shape} in
the call to the geom - just use \code{shape}.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_edge_width}},
  \code{\link{scale_label_size}}
}
