% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_grid_paginate.R
\name{facet_grid_paginate}
\alias{facet_grid_paginate}
\title{Split facet_grid over multiple plots}
\usage{
facet_grid_paginate(
  facets,
  margins = FALSE,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  ncol = NULL,
  nrow = NULL,
  page = 1,
  byrow = TRUE
)
}
\arguments{
\item{facets}{This argument is soft-deprecated, please use \code{rows}
and \code{cols} instead.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{space}{If \code{"fixed"}, the default, all panels have the same size.
If \code{"free_y"} their height will be proportional to the length of the
y scale; if \code{"free_x"} their width will be proportional to the
length of the x scale; or if \code{"free"} both height and width will
vary.  This setting has no effect unless the appropriate scales also vary.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{ncol}{Number of columns per page}

\item{nrow}{Number of rows per page}

\item{page}{The page to draw}

\item{byrow}{Should the pages be created row-wise or column wise}
}
\description{
This extension to \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} will allow you to split
a facetted plot over multiple pages. You define a number of rows and columns
per page as well as the page number to plot, and the function will
automatically only plot the correct panels. Usually this will be put in a
loop to render all pages one by one.
}
\note{
If either \code{ncol} or \code{nrow} is \code{NULL} this function will
fall back to the standard \code{facet_grid} functionality.
}
\examples{
# Draw a small section of the grid
ggplot(diamonds) +
  geom_point(aes(carat, price), alpha = 0.1) +
  facet_grid_paginate(color ~ cut:clarity, ncol = 3, nrow = 3, page = 4)
}
\seealso{
\code{\link[=n_pages]{n_pages()}} to compute the total number of pages in a paginated
faceted plot

Other ggforce facets: 
\code{\link{facet_stereo}()},
\code{\link{facet_wrap_paginate}()},
\code{\link{facet_zoom}()}
}
\concept{ggforce facets}
