% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{Gompertz}
\alias{Gompertz}
\title{Gompertz Curve constructor function}
\usage{
Gompertz(theta, eta)
}
\arguments{
\item{theta}{Scale parameter for Log-logistic distribution.}

\item{eta}{Shape parameter for Log-logistic distribution.}
}
\description{
This creates a Curve object for a Gompertz distribution.\cr
Curve objects contain all necessary information to describe a distribution, including functions and parameters describing it.\cr
See Details for information on parameterisation.
}
\details{
The Gompertz distribution has parameterisation:\cr
f(x) = theta eta e^(eta + theta x - eta e^(theta x))\cr
F(x) = 1 - exp(eta - eta e^(theta x))
}
\examples{
Gompertz(theta=0.02,eta=2)
}
\author{
Jasmin Ruehl
}
