% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_geo.R
\name{set_metadata}
\alias{set_metadata}
\alias{set_metadata.acs_5yr_geo}
\title{Set metadata layer}
\usage{
set_metadata(geo, metadata)

\method{set_metadata}{acs_5yr_geo}(geo, metadata)
}
\arguments{
\item{geo}{An \code{acs_5yr_geo} object.}

\item{metadata}{A \code{tibble} object.}
}
\value{
A \code{sf} object.
}
\description{
The metadata layer includes the names and description through various fields
of the variables contained in the reports.
}
\details{
When we set the metadata layer, after filtering it, the data layer is also
filtered keeping only the variables from the metadata layer.
}
\examples{

act <- anrc_2021_x01 |>
  select_report(report = "B01002-Median Age By Sex")

geo <- act |>
  as_acs_5yr_geo()

metadata <- geo |>
  get_metadata()

metadata <- dplyr::filter(metadata, item2 == "Female")

geo2 <- geo |>
  set_metadata(metadata)

}
\seealso{
Other data exploitation and export functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_acs_5yr_geo}()},
\code{\link{as_flat_table}()},
\code{\link{as_star_database}()},
\code{\link{get_metadata}()}
}
\concept{data exploitation and export functions}
