% Generated by roxygen2 (4.0.2): do not edit by hand
\name{geocodeHERE_batch_get_data}
\alias{geocodeHERE_batch_get_data}
\title{Gets the results of a batch geocoding job}
\usage{
geocodeHERE_batch_get_data(request_id = "", App_id = "", App_code = "")
}
\arguments{
\item{request_id}{Character string containing a request_id. This is returned from geocodeHERE_batch_upload(...)}

\item{App_id}{App_id to use the production HERE API. Get one here... http://developer.here.com/get-started. If left blank, will default to demo key with an unknown usage limit.}

\item{App_code}{App_code to use the production HERE API. Get one here... http://developer.here.com/get-started. If left blank, will default to demo key with an unknown usage limit.}
}
\value{
Dataframe of results from the geocoding job
}
\description{
Download the result to a temp file, extract zip, read pipe delimited file, return as dataframe
}
\examples{
addresses <- chicago_landmarks[,"Address"]
addresses <- paste(addresses, "chicago IL")
addresses_df <- data.frame(id=1:length(addresses), addresses=addresses)
address_str <- df_to_string(addresses_df)
\donttest{
request_id <- geocodeHERE_batch_upload(address_string = address_str,
                                       email_address = "youremail<at>domain.com")
geocodeHERE_batch_status(request_id)
geocode_data <- geocodeHERE_batch_get_data(request_id)
addresses_df <- merge(addresses_df, geocode_data, by.x="id", by.y="recId", all.x=T)
}
}
\keyword{batch}
\keyword{geocode}

