% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\docType{methods}
\name{spc.plot.overlay}
\alias{spc.plot.overlay}
\alias{spc.plot.overlay,SpcList-method}
\title{Plotting multiple \code{Spectra} objects inside a \code{SpcList}}
\usage{
spc.plot.overlay(object,lab_cex,leg_idx, type, lty,lwd, col, ...)

\S4method{spc.plot.overlay}{SpcList}(object, lab_cex = 1, leg_idx = TRUE,
  type = "l", lty = 1, lwd = 1, col, ...)
}
\arguments{
\item{object}{A \code{SpcList} data}

\item{lab_cex}{vector of character expansion sizes, used cyclically}

\item{leg_idx}{logical If it is of length 1, it determines whether or not to display the legend.
If length(leg_idx) is bigger than 1, then its lengths has to equal length(object). Default is TRUE.}

\item{type}{character string (length 1 vector) or vector of 1-character strings indicating the type of plot for each column of y,}

\item{lty}{vector of line types. See par().}

\item{lwd}{numeric. Vector of line widths. See par().}

\item{col}{A specification for the default plotting color. See par().}

\item{...}{any further arguments to the plotting function matplot() or spc.plot()}
}
\description{
This function overlays spectra plots of several \code{Spectra} objects inside a 
\code{SpcList} object. The first element of the input \code{SpcList} object
is plotted with spc.plot() while remaining elements are overlaid with spc.lines().
}
\examples{
sp <- spc.example_spectra()
BL = spc.makeSpcList(sp,"CAST")
spc.plot.overlay(BL)
spc.plot.overlay(BL, xlim=c(400,500),ylim=c(0,0.2),lwd=2)
spc.plot.overlay(BL, col=c("red"), leg_idx=FALSE, lty=2)
spc.plot.overlay(BL, col=c("red","blue","green","yellow","cyan","black"))

}
