% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{get_postfix_rule}
\alias{get_postfix_rule}
\title{Changes a logical expression in infix notation to postfix notation using the shunting-yard algorithm.}
\usage{
get_postfix_rule(rule, num_eqs)
}
\arguments{
\item{rule}{A string containing positive integers, parentheses, and \code{"&"} and \code{"|"} only. \code{"&&"} and \code{"&"} are not differentiated, and similarly for \code{"||"} and \code{"|"}. Chained operations are only allowed for the same operation (\code{"&"} or \code{"|"}), so instead of \code{"1 && 2 || 3"} one should write either \code{"(1 && 2) || 3"} or \code{"1 && (2 || 3)"} to avoid ambiguity.}

\item{num_eqs}{An integer, must be larger than or equal to the largest integer appearing in \code{rule}.}
}
\value{
\code{rule} in postfix notation.
}
\description{
Changes a logical expression in infix notation to postfix notation using the shunting-yard algorithm.
}
\details{
Applied to \code{domain$rule} if \code{domain$type == "polynomial"}, and internally calls \code{beautify_rule()}.
}
\examples{
get_postfix_rule("1 & 2 && 3", 3)
get_postfix_rule("1 & (2 || 3)", 3)
get_postfix_rule("(1 & 2) || 3 | (4 & (5 || 6) && 7) | 8 | (9 && (10 || 11 | 12) & 13)", 13)
\dontrun{
get_postfix_rule("1 && 2 & 3 && 4", 3) # Error, ineq number 4 appearing in \code{rule}.
}
\dontrun{
# Error, ambigious rule. Change to either \code{"1 & (2 | 3)"} or \code{"(1 & 2) | 3"}.
get_postfix_rule("1 & 2 | 3", 3)
}
}
