\name{ArtCohort-class}
\Rdversion{1.1}
\docType{class}
\alias{ArtCohort-class}
\alias{[,ArtCohort-method}
\alias{[,ArtCohort,ANY,ANY,ANY-method}
\alias{summary,ArtCohort-method}
\alias{update,ArtCohort-method}
\alias{head,ArtCohort-method}
\alias{tail,ArtCohort-method}

\title{Class \code{"ArtCohort"}}
\description{
  Is a S4 class for the artificial cohort generated by \code{simulateCohort}.
}
\section{Objects from the Class}{
  Objects are created by calls to the function \code{simulateCohort}.
}
\section{Slots}{
  \describe{
    \item{\code{states.number}:}{Object of class \code{"numeric"}: number of states }
    \item{\code{size}:}{Object of class \code{"numeric"}: cohort size }
    \item{\code{baseline}:}{Object of class \code{"matrix"}: baseline matrix }
    \item{\code{follow.up}:}{Object of class \code{"numeric"}: maximum follow-up time}
    \item{\code{parameters}:}{Object of class
      \code{"transition.structure"}: input parameters }
    \item{\code{parametersCovariances}:}{Object of class \code{"transition.structure"}: input covariance matrices }
    \item{\code{timeToTransition}:}{Object of class \code{"matrix"}:
      input timeToTransition matrix. logical components}
    \item{\code{transitionFunctions}:}{Object of class \code{"transition.structure"}: input hazard functions }
    \item{\code{time.to.state}:}{Object of class \code{"data.frame"}: entry times for each patient into each of the states }
  }
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "ArtCohort", i="ANY", j="ANY", drop="ANY")}: extract subsets of slot \code{time.to.state} in artificial cohorts }
    \item{summary}{\code{signature(object = "ArtCohort")}: summarize the artificial cohort }
    \item{update}{\code{signature(object = "ArtCohort")}: update an artificial cohort }
    \item{head}{\code{signature(x = "ArtCohort")}: returns the first part of the artificial cohort }
    \item{tail}{\code{signature(x = "ArtCohort")}: returns the last part of the artificial cohort }
	 }
}
\author{
  Luisa Salazar Vizcaya, Nello Blaser, Thomas Gsponer
}

\seealso{
  \code{\link{simulateCohort}},
  \code{\link{transition.structure-class}},
  \code{\link{transitionProbabilities}},  
  \code{\link{cumulativeIncidence}}
}
\examples{
showClass("ArtCohort")
}
\keyword{classes}
