`super.plot.phylo` <-
function(phy, data, file=NULL, ...)
{
	n 	 <- nrow(data)
	cols <- ncol(data)
	#--------------------------------------
	#---- INTERNAL CONSISTENCY CHECK   ----
	#--------------------------------------
	if (class(phy) != "phylo")
		stop("object \"phy\" is not of class \"phylo\"")
	if (sum(sort(rownames(data))==sort(phy$tip.label))!=n)
		stop("Data row names and object \"phy\" do not have the same names")
	#----------------------------------
	#---- CREATE NEW PLOT DEVICE   ----
	#----------------------------------
	if (!is.null(file)){
    	pdf(file=file, width=11, height=8.5, family="Helvetica") 
    }else {plot.new()}
	plot.new()
	par(mar=c(3,2,4,10))   			# Set right margins for room
	#-----------------
	#--- PLOT PHY ---
	#-----------------
	plot.phylo(phy, no.margin=FALSE, ...)
		#---- SCALE
		axisPhylo(side=1)
		add.scale.bar(length=1)
		text(1.4,1, "Millions of yrs", pos=4)
	#---- TITLE
	#-----------------
	#--- PLOT TIPS ---
	#-----------------       
	par(new=TRUE, mar=c(3,2,4,1)) # Reset plot margins
	plot.new()
		spacing <- 1/(n-1)
		spp.order <- phy$tip.label
		for (i in 1:n) {
			text(0.86, spacing*(i-1), data[rownames(data)==spp.order[i],1])
			text(0.96, spacing*(i-1), data[rownames(data)==spp.order[i],2])
		}
	par(new=TRUE, mar=c(3,2,2,1)) # Reset plot margins
	plot.new()
		text(0.86, 1, paste(colnames(data)[1]))
		text(0.96, 1, paste(colnames(data)[2]))
		lines( c(0.82, 1),c(.95,0.95), lty="dotted")
		abline(v=0.82, lty="dotted")
		abline(v=0.91, lty="dotted")
		abline(v=1.00, lty="dotted")
	if (!is.null(file)){
		dev.off()
		}
}

