% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalmdiminfo.R
\name{gdalmdiminfo}
\alias{gdalmdiminfo}
\title{Interface to GDAL's gdalmdiminfo utility}
\usage{
gdalmdiminfo(
  datasetname,
  ...,
  oo,
  arrayoption,
  detailed,
  nopretty,
  array,
  limit,
  stats,
  IF,
  dryrun = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{datasetname}{Path to a GDAL-supported readable datasource.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{oo, arrayoption, detailed, nopretty, array, limit, stats, IF}{the
GDAL project's
\href{https://gdal.org/programs/gdalmdiminfo.html}{gdalmdiminfo
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}

\item{quiet}{Logical (default \code{FALSE}). If \code{TRUE},
suppress printing of output to the console.}
}
\value{
Silently returns a character vector containing the
    information in JSON format returned by the gdalmdiminfo
    utility.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{gdalmdiminfo}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/gdalmdiminfo.html}.
}
\examples{
ff <- system.file("nc/cropped.nc", package = "sf")
gdalmdiminfo(ff)
}
\author{
Joshua O'Brien
}
