% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{awipe}
\alias{awipe}
\title{Generalized array's sweep() for data cleaning.}
\usage{
awipe(X, FUN = "-", STATS = "mean", MARGIN = NULL, MoreArgs = NULL,
  ..., SIMPLIFY = TRUE, VECTORIZED = NA)
}
\arguments{
\item{X}{A generalized array.}

\item{FUN}{The wiping function.}

\item{STATS}{Numeric array or function.}

\item{MARGIN}{NULL - STATS is an array; character - STATS is a function,
and by X being reduced along MARGIN, X is wiped.  Length 0 character
vector means reducing along no margin, resulting in a scalar (in
this case, for example, \code{areduce(sum, X)} is the same as \code{sum(X)}.}

\item{MoreArgs, SIMPLIFY, VECTORIZED}{Argument used by 'amap()'.}

\item{...}{Argument used by 'areduce()'.}
}
\description{
Return a generalized array, by wiping out a summary statistic.
}
\examples{
a <- garray(1:24, c(4,6), list(X=LETTERS[1:4], Y=letters[1:6]),
	sdim=list(XX=c(x1=3,x2=1), YY=c(y1=1,y2=2)))
m1 <- awipe(a, MARGIN="XX")
m2 <- awipe(a, `-`, mean, "XX")
}
