% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-properties.R
\name{graph-is}
\alias{graph-is}
\alias{is_dag}
\alias{is.adjMAT}
\alias{is_dagMAT}
\alias{is_ug}
\alias{is_ug.graphNEL}
\alias{is_ug.igraph}
\alias{is_ug.default}
\alias{is_ugMAT}
\alias{is_tug}
\alias{is_tugMAT}
\alias{is_dg}
\alias{is_dgMAT}
\title{Check properties of graphs.}
\usage{
is_dag(object)

is_dagMAT(object)

is_ug(object)

\method{is_ug}{graphNEL}(object)

\method{is_ug}{igraph}(object)

\method{is_ug}{default}(object)

is_ugMAT(object)

is_tug(object)

is_tugMAT(object)

is_dg(object)

is_dgMAT(object)
}
\arguments{
\item{object}{A graph represented as 1) graphNEL (from the graph
package), 2) an adjacency matrix, 3) a sparse adjacency matrix
(a dgCMatrix from the Matrix package).}
}
\description{
Check if a graph is 1) a directed acyclic graph (DAG),
    2) a directed graph (DG), 3) an undirected graph (UG), 4) a
    triangulated (chordal) undirected graph (TUG). This is done for
    graphs represented as 1) graphNEL (from the graph package), 2)
    an adjacency matrix, 3) a sparse adjacency matrix (a dgCMatrix
    from the Matrix package).
}
\details{
A non-zero value at entry (i,j) in an adjacency matrix A
    for a graph means that there is an edge from i to j. If also
    (j,i) is non-zero there is also an edge from j to i. In this
    case we may think of a bidirected edge between i and j or we
    may think of the edge as being undirected.  We do not
    distinguish between undirected and bidirected edges in the
    gRbase package.  On the other hand, graphNEL objects from the
    graph package makes such a distinction (the function
    \code{edgemode()} will tell if edges are "directed" or
    "undirected" in a graphNEL object).

The function \code{is_ug()} checks if the adjacency matrix is
symmetric (If applied to a graphNEL, the adjacency matrix is
created and checked for symmetry.)

The function \code{is_tug()} checks if the graph is undirected and
triangulated (also called chordal) by checking if the adjacency matrix is
symmetric and the vertices can be given a perfect ordering using maximum
cardinality seach.

The function \code{is_dg()} checks if a graph is directed, i.e., that there
are no undirected edges. This is done by computing the elementwise product
of A and the transpose of A; if there are no non--zero entries in this
product then the graph is directed.

The function \code{is_dag()} will return \code{TRUE} if all edges are
directed and if there are no cycles in the graph. (This is checked by
checking if the vertices in the graph can be given a topological ordering
which is based on identifying an undirected edge with a bidrected edge).

There is a special case, namely if the graph has no edges at all (such that
the adjacency matrix consists only of zeros). Such a graph is both
undirected, triangulated, directed and directed acyclic.
}
\examples{

## DAGs
dagNEL  <- dag(~ a:b:c + c:d:e, result="graphNEL")
dagMAT  <- dag(~ a:b:c + c:d:e, result="matrix")
dagMATS <- dag(~ a:b:c + c:d:e, result="dgCMatrix")

## Undirected graphs
ugNEL  <- ug(~a:b:c + c:d:e, result="graphNEL")
ugMAT  <- ug(~a:b:c + c:d:e, result="matrix")
ugMATS <- ug(~a:b:c + c:d:e, result="dgCMatrix")

## Is it a DAG?
is_dag(dagNEL)
is_dag(dagMAT)
is_dag(dagMATS)

is_dag(ugNEL)
is_dag(ugMAT)
is_dag(ugMATS)

## Is it an undirected graph
is_ug(dagNEL)
is_ug(dagMAT)
is_ug(dagMATS)

is_ug(ugNEL)
is_ug(ugMAT)
is_ug(ugMATS)

## Is it a triangulated (i.e. chordal)  undirected graph
is_tug(dagNEL)
is_tug(dagMAT)
is_tug(dagMATS)

is_tug(ugNEL)
is_tug(ugMAT)
is_tug(ugMATS)

## Example where the graph is not triangulated
ug2NEL  <- ug(~ a:b + b:c + c:d + d:a, result="graphNEL")
ug2MAT  <- ug(~ a:b + b:c + c:d + d:a, result="matrix")
ug2MATS <- ug(~ a:b + b:c + c:d + d:a, result="dgCMatrix")

is_tug(ug2NEL)
is_tug(ug2MAT)
is_tug(ug2MATS)

## Bidirected graphs
graph::edgemode(ugNEL)
graph::edgemode(ugNEL) <- "directed"
graph::edgemode(ugNEL)
is_dag(ugNEL)
is_ug(ugNEL)

}
\seealso{
\code{\link{dag}}, \code{\link{ug}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
