% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndset.R
\name{addNDSet2D}
\alias{addNDSet2D}
\title{Add 2D discrete points to a non-dominated set and classify them into extreme
supported, non-extreme supported, non-supported.}
\usage{
addNDSet2D(pts, nDSet = NULL, crit = "max", keepDom = FALSE)
}
\arguments{
\item{pts}{A data frame. It is assumed that z1 and z2 are in the two first columns.}

\item{nDSet}{A data frame with current non-dominated set (NULL is none yet).}

\item{crit}{Either max or min.}

\item{keepDom}{Keep dominated points.}
}
\value{
A data frame with columns z1 and z2, nD (non-dominated),
ext (extreme), nonExt (non-extreme supported).
}
\description{
Add 2D discrete points to a non-dominated set and classify them into extreme
supported, non-extreme supported, non-supported.
}
\examples{
nDSet <- data.frame(z1=c(12,14,16,18), z2=c(18,16,12,4))
pts <- data.frame(z1 = c(18,18,14,15,15), z2=c(2,6,14,14,16))
addNDSet2D(pts, nDSet, crit = "max")
addNDSet2D(pts, nDSet, crit = "max", keepDom = TRUE)
addNDSet2D(pts, nDSet, crit = "min")
}
\author{
Lars Relund \email{lars@relund.dk}
}
