% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.apply-package.R
\docType{package}
\name{future.apply}
\alias{future.apply}
\alias{future.apply-package}
\title{future.apply: Apply Function to Elements in Parallel using Futures}
\description{
The \pkg{future.apply} packages provides parallel implementations of
common "apply" functions provided by base \R.  The parallel processing
is performed via the \pkg{future} ecosystem, which provides a large
number of parallel backends, e.g. on the local machine, a remote cluster,
and a high-performance compute cluster.
}
\details{
Currently implemented functions are:
\itemize{
\item \code{\link[=future_apply]{future_apply()}}: a parallel version of \link[base:apply]{apply()}
\item \code{\link[=future_by]{future_by()}}: a parallel version of \link[base:by]{by()}
\item \code{\link[=future_eapply]{future_eapply()}}: a parallel version of \link[base:lapply]{eapply()}
\item \code{\link[=future_lapply]{future_lapply()}}: a parallel version of \link[base:lapply]{lapply()}
\item \code{\link[=future_mapply]{future_mapply()}}: a parallel version of \link[base:mapply]{mapply()}
\item \code{\link[=future_sapply]{future_sapply()}}: a parallel version of \link[base:lapply]{sapply()}
\item \code{\link[=future_tapply]{future_tapply()}}: a parallel version of \link[base:tapply]{tapply()}
\item \code{\link[=future_vapply]{future_vapply()}}: a parallel version of \link[base:lapply]{vapply()}
\item \code{\link[=future_Map]{future_Map()}}: a parallel version of \link[base:funprog]{Map()}
\item \code{\link[=future_replicate]{future_replicate()}}: a parallel version of \link[base:lapply]{replicate()}
\item \code{\link[=future_.mapply]{future_.mapply()}}: a parallel version of \link[base:mapply]{.mapply()}
}

Reproducibility is part of the core design, which means that perfect,
parallel random number generation (RNG) is supported regardless of the
amount of chunking, type of load balancing, and future backend being used.

Since these \verb{future_*()} functions have the same arguments as the
corresponding base \R function, start using them is often as simple as
renaming the function in the code.  For example, after attaching the package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(future.apply)
}\if{html}{\out{</div>}}

code such as:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- list(a = 1:10, beta = exp(-3:3), logic = c(TRUE,FALSE,FALSE,TRUE))
y <- lapply(x, quantile, probs = 1:3/4)
}\if{html}{\out{</div>}}

can be updated to:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{y <- future_lapply(x, quantile, probs = 1:3/4)
}\if{html}{\out{</div>}}

The default settings in the \pkg{future} framework is to process code
\emph{sequentially}.  To run the above in parallel on the local machine
(on any operating system), use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{plan(multisession)
}\if{html}{\out{</div>}}

first.  That's it!

To go back to sequential processing, use \code{plan(sequential)}.
If you have access to multiple machines on your local network, use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{plan(cluster, workers = c("n1", "n2", "n2", "n3"))
}\if{html}{\out{</div>}}

This will set up four workers, one on \code{n1} and \code{n3}, and two on \code{n2}.
If you have SSH access to some remote machines, use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{plan(cluster, workers = c("m1.myserver.org", "m2.myserver.org))
}\if{html}{\out{</div>}}

See the \pkg{future} package and \code{\link[future:plan]{future::plan()}} for more examples.

The \pkg{future.batchtools} package provides support for high-performance
compute (HPC) cluster schedulers such as SGE, Slurm, and TORQUE / PBS.
For example,
\itemize{
\item \code{plan(batchtools_slurm)}:
Process via a Slurm scheduler job queue.
\item \code{plan(batchtools_torque)}:
Process via a TORQUE / PBS scheduler job queue.
}

This builds on top of the queuing framework that the \pkg{batchtools}
package provides. For more details on backend configuration, please see
the \pkg{future.batchtools} and \pkg{batchtools} packages.

These are just a few examples of parallel/distributed backend for the
future ecosystem.  For more alternatives, see the 'Reverse dependencies'
section on the
\href{https://cran.r-project.org/package=future}{future CRAN package page}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://future.apply.futureverse.org}
  \item \url{https://github.com/futureverse/future.apply}
  \item Report bugs at \url{https://github.com/futureverse/future.apply/issues}
}

}
\author{
Henrik Bengtsson, except for the implementations of \code{future_apply()},
\code{future_Map()}, \code{future_replicate()}, \code{future_sapply()}, and
\code{future_tapply()}, which are adopted from the source code of the
corresponding base \R functions, which are licensed under GPL (>= 2)
with 'The R Core Team' as the copyright holder.
Because of these dependencies, the license of this package is GPL (>= 2).
}
\keyword{iteration}
\keyword{manip}
\keyword{programming}
