/* MLPACK 0.2
 *
 * Copyright (c) 2008, 2009 Alexander Gray,
 *                          Garry Boyer,
 *                          Ryan Riegel,
 *                          Nikolaos Vasiloglou,
 *                          Dongryeol Lee,
 *                          Chip Mappus, 
 *                          Nishant Mehta,
 *                          Hua Ouyang,
 *                          Parikshit Ram,
 *                          Long Tran,
 *                          Wee Chin Wong
 *
 * Copyright (c) 2008, 2009 Georgia Institute of Technology
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */
/*
 * Declarations of the LAPACK functions in their native fortran state.
 *
 * Procured from NETLIB. TODO: Include copyright notice.
 */

#ifndef LA_CLAPACK_H
#define LA_CLAPACK_H

#include "../base/fortran.h"
#include "../base/compiler.h"
namespace la {

extern "C" {

f77_ret_void F77_FUNC(cbdsqr)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_real *d__, f77_real *e, f77_complex *vt, f77_integer CONST_REF ldvt, f77_complex *u, f77_integer CONST_REF ldu, f77_complex *c__, f77_integer CONST_REF ldc, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgbbrd)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF ncc, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *d__, f77_real *e, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *pt, f77_integer CONST_REF ldpt, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgbcon)(const char *norm, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgbequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(cgbrfs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgbsv)(f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cgbsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, const char *equed, f77_real *r__, f77_real *c__, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgbtf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(cgbtrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(cgbtrs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cgebak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_integer CONST_REF m, f77_complex *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(cgebal)(const char *job, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_integer *info);
f77_ret_void F77_FUNC(cgebd2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_complex *tauq, f77_complex *taup, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgebrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_complex *tauq, f77_complex *taup, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgecon)(const char *norm, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(cgees)(const char *jobvs, const char *sort, f77_logical_func select, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_complex *w, f77_complex *vs, f77_integer CONST_REF ldvs, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeesx)(const char *jobvs, const char *sort, f77_logical_func select, const char *sense, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_complex *w, f77_complex *vs, f77_integer CONST_REF ldvs, f77_real *rconde, f77_real *rcondv, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *w, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *w, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_real *abnrm, f77_real *rconde, f77_real *rcondv, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgegs)(const char *jobvsl, const char *jobvsr, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *vsl, f77_integer CONST_REF ldvsl, f77_complex *vsr, f77_integer CONST_REF ldvsr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgegv)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgehd2)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgehrd)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgelq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgelqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgels)(const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgelsx)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_real *rcond, f77_integer *rank, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgelsy)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_real *rcond, f77_integer *rank, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeql2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgeqlf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeqp3)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeqpf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_complex *tau, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgeqr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgeqrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgerfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgerq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgerqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgesc2)(f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *rhs, f77_integer *ipiv, f77_integer *jpiv, f77_real *scale);
f77_ret_void F77_FUNC(cgesv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cgesvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, const char *equed, f77_real *r__, f77_real *c__, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgetc2)(f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *jpiv, f77_integer *info);
f77_ret_void F77_FUNC(cgetf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(cgetrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(cgetri)(f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgetrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cggbak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_integer CONST_REF m, f77_complex *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(cggbal)(const char *job, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(cgges)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func selctg, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_complex *alpha, f77_complex *beta, f77_complex *vsl, f77_integer CONST_REF ldvsl, f77_complex *vsr, f77_integer CONST_REF ldvsr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(cggesx)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func selctg, const char *sense, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_complex *alpha, f77_complex *beta, f77_complex *vsl, f77_integer CONST_REF ldvsl, f77_complex *vsr, f77_integer CONST_REF ldvsr, f77_real *rconde, f77_real *rcondv, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(cggev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cggevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_real *abnrm, f77_real *bbnrm, f77_real *rconde, f77_real *rcondv, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *iwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(cggglm)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *d__, f77_complex *x, f77_complex *y, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cgghrd)(const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(cgglse)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_complex *d__, f77_complex *x, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cggqrf)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_complex *a, f77_integer CONST_REF lda, f77_complex *taua, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *taub, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cggrqf)(f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *taua, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *taub, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cggsvd)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_integer CONST_REF k, f77_integer *l, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *alpha, f77_real *beta, f77_complex *u, f77_integer CONST_REF ldu, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(cggsvp)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *tola, f77_real *tolb, f77_integer CONST_REF k, f77_integer *l, f77_complex *u, f77_integer CONST_REF ldu, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *q, f77_integer CONST_REF ldq, f77_integer *iwork, f77_real *rwork, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgtcon)(const char *norm, f77_integer CONST_REF n, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *du2, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cgtrfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *dlf, f77_complex *df, f77_complex *duf, f77_complex *du2, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgtsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cgtsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *dlf, f77_complex *df, f77_complex *duf, f77_complex *du2, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cgttrf)(f77_integer CONST_REF n, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *du2, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(cgttrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *du2, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cgtts2)(f77_integer *itrans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *du2, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(chbev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chbevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(chbevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *q, f77_integer CONST_REF ldq, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(chbgst)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *bb, f77_integer CONST_REF ldbb, f77_complex *x, f77_integer CONST_REF ldx, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chbgv)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *bb, f77_integer CONST_REF ldbb, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chbgvx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *bb, f77_integer CONST_REF ldbb, f77_complex *q, f77_integer CONST_REF ldq, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(chbtrd)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *d__, f77_real *e, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(checon)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cheev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *w, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cheevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *w, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(cheevr)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(cheevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(chegs2)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(chegst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(chegv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *w, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chegvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *w, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(chegvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(cherfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chesv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(chesvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chetf2)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(chetrd)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(chetrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(chetri)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(chetrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(chgeqz)(const char *job, const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chpcon)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(chpev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chpevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(chpevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(chpgst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_complex *bp, f77_integer *info);
f77_ret_void F77_FUNC(chpgv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_complex *bp, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chpgvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_complex *bp, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(chpgvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_complex *bp, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(chprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chpsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(chpsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(chptrd)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *d__, f77_real *e, f77_complex *tau, f77_integer *info);
f77_ret_void F77_FUNC(chptrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(chptri)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(chptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(chsein)(const char *side, const char *eigsrc, const char *initv, f77_logical *select, f77_integer CONST_REF n, f77_complex *h__, f77_integer CONST_REF ldh, f77_complex *w, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_complex *work, f77_real *rwork, f77_integer *ifaill, f77_integer *ifailr, f77_integer *info);
f77_ret_void F77_FUNC(chseqr)(const char *job, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *h__, f77_integer CONST_REF ldh, f77_complex *w, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(clabrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *nb, f77_complex *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_complex *tauq, f77_complex *taup, f77_complex *x, f77_integer CONST_REF ldx, f77_complex *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(clacgv)(f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(clacon)(f77_integer CONST_REF n, f77_complex *v, f77_complex *x, f77_real *est, f77_integer *kase);
f77_ret_void F77_FUNC(clacp2)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(clacpy)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(clacrm)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_integer CONST_REF ldc, f77_real *rwork);
f77_ret_void F77_FUNC(clacrt)(f77_integer CONST_REF n, f77_complex *cx, f77_integer CONST_REF incx, f77_complex *cy, f77_integer CONST_REF incy, f77_complex *c__, f77_complex *s);
f77_ret_void F77_FUNC(claed0)(f77_integer *qsiz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *qstore, f77_integer CONST_REF ldqs, f77_real *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(claed7)(f77_integer CONST_REF n, f77_integer *cutpnt, f77_integer *qsiz, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_real *d__, f77_complex *q, f77_integer CONST_REF ldq, f77_real *rho, f77_integer *indxq, f77_real *qstore, f77_integer *qptr, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_real *givnum, f77_complex *work, f77_real *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(claed8)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *qsiz, f77_complex *q, f77_integer CONST_REF ldq, f77_real *d__, f77_real *rho, f77_integer *cutpnt, f77_real *z__, f77_real *dlamda, f77_complex *q2, f77_integer CONST_REF ldq2, f77_real *w, f77_integer *indxp, f77_integer *indx, f77_integer *indxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_real *givnum, f77_integer *info);
f77_ret_void F77_FUNC(claein)(f77_logical *rightv, f77_logical *noinit, f77_integer CONST_REF n, f77_complex *h__, f77_integer CONST_REF ldh, f77_complex *w, f77_complex *v, f77_complex *b, f77_integer CONST_REF ldb, f77_real *rwork, f77_real *eps3, f77_real *smlnum, f77_integer *info);
f77_ret_void F77_FUNC(claesy)(f77_complex *a, f77_complex *b, f77_complex *c__, f77_complex *rt1, f77_complex *rt2, f77_complex *evscal, f77_complex *cs1, f77_complex *sn1);
f77_ret_void F77_FUNC(claev2)(f77_complex *a, f77_complex *b, f77_complex *c__, f77_real *rt1, f77_real *rt2, f77_real *cs1, f77_complex *sn1);
f77_ret_void F77_FUNC(clags2)(f77_logical *upper, f77_real *a1, f77_complex *a2, f77_real *a3, f77_real *b1, f77_complex *b2, f77_real *b3, f77_real *csu, f77_complex *snu, f77_real *csv, f77_complex *snv, f77_real *csq, f77_complex *snq);
f77_ret_void F77_FUNC(clagtm)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *alpha, f77_complex *dl, f77_complex *d__, f77_complex *du, f77_complex *x, f77_integer CONST_REF ldx, f77_real *beta, f77_complex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(clahef)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(clahqr)(f77_logical CONST_REF wantt, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *h__, f77_integer CONST_REF ldh, f77_complex *w, f77_integer *iloz, f77_integer *ihiz, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(clahrd)(f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *nb, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(claic1)(f77_integer *job, f77_integer *j, f77_complex *x, f77_real *sest, f77_complex *w, f77_complex *gamma, f77_real *sestpr, f77_complex *s, f77_complex *c__);
f77_ret_void F77_FUNC(clals0)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF nrhs, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *bx, f77_integer CONST_REF ldbx, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_real *givnum, f77_integer CONST_REF ldgnum, f77_real *poles, f77_real *difl, f77_real *difr, f77_real *z__, f77_integer CONST_REF k, f77_real *c__, f77_real *s, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(clalsa)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *bx, f77_integer CONST_REF ldbx, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF k, f77_real *difl, f77_real *difr, f77_real *z__, f77_real *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_real *givnum, f77_real *c__, f77_real *s, f77_real *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(clapll)(f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF incx, f77_complex *y, f77_integer CONST_REF incy, f77_real *ssmin);
f77_ret_void F77_FUNC(clapmt)(f77_logical *forwrd, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF ldx, f77_integer CONST_REF k);
f77_ret_void F77_FUNC(claqgb)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqge)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqhb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqhe)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqhp)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqp2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_complex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_complex *tau, f77_real *vn1, f77_real *vn2, f77_complex *work);
f77_ret_void F77_FUNC(claqps)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_integer *nb, f77_integer *kb, f77_complex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_complex *tau, f77_real *vn1, f77_real *vn2, f77_complex *auxv, f77_complex *f, f77_integer CONST_REF ldf);
f77_ret_void F77_FUNC(claqsb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqsp)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(claqsy)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(clar1v)(f77_integer CONST_REF n, f77_integer *b1, f77_integer *bn, f77_real *sigma, f77_real *d__, f77_real *l, f77_real *ld, f77_real *lld, f77_real *gersch, f77_complex *z__, f77_real *ztz, f77_real *mingma, f77_integer *r__, f77_integer *isuppz, f77_real *work);
f77_ret_void F77_FUNC(clar2v)(f77_integer CONST_REF n, f77_complex *x, f77_complex *y, f77_complex *z__, f77_integer CONST_REF incx, f77_real *c__, f77_complex *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(clarcm)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_integer CONST_REF ldc, f77_real *rwork);
f77_ret_void F77_FUNC(clarf)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *v, f77_integer CONST_REF incv, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work);
f77_ret_void F77_FUNC(clarfb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(clarfg)(f77_integer CONST_REF n, f77_complex *alpha, f77_complex *x, f77_integer CONST_REF incx, f77_complex *tau);
f77_ret_void F77_FUNC(clarft)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *tau, f77_complex *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(clarfx)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *v, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work);
f77_ret_void F77_FUNC(clargv)(f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF incx, f77_complex *y, f77_integer CONST_REF incy, f77_real *c__, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(clarnv)(f77_integer *idist, f77_integer *iseed, f77_integer CONST_REF n, f77_complex *x);
f77_ret_void F77_FUNC(clarrv)(f77_integer CONST_REF n, f77_real *d__, f77_real *l, f77_integer *isplit, f77_integer CONST_REF m, f77_real *w, f77_integer *iblock, f77_real *gersch, f77_real *tol, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(clartg)(f77_complex *f, f77_complex *g, f77_real *cs, f77_complex *sn, f77_complex *r__);
f77_ret_void F77_FUNC(clartv)(f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF incx, f77_complex *y, f77_integer CONST_REF incy, f77_real *c__, f77_complex *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(clarz)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_complex *v, f77_integer CONST_REF incv, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work);
f77_ret_void F77_FUNC(clarzb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(clarzt)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *tau, f77_complex *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(clascl)(const char *type__, f77_integer *kl, f77_integer *ku, f77_real *cfrom, f77_real *cto, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(claset)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *alpha, f77_complex *beta, f77_complex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(clasr)(const char *side, const char *pivot, const char *direct, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *c__, f77_real *s, f77_complex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(classq)(f77_integer CONST_REF n, f77_complex *x, f77_integer CONST_REF incx, f77_real *scale, f77_real *sumsq);
f77_ret_void F77_FUNC(claswp)(f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *k1, f77_integer *k2, f77_integer *ipiv, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(clasyf)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(clatbs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(clatdf)(f77_integer *ijob, f77_integer CONST_REF n, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *rhs, f77_real *rdsum, f77_real *rdscal, f77_integer *ipiv, f77_integer *jpiv);
f77_ret_void F77_FUNC(clatps)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_complex *ap, f77_complex *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(clatrd)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_complex *a, f77_integer CONST_REF lda, f77_real *e, f77_complex *tau, f77_complex *w, f77_integer CONST_REF ldw);
f77_ret_void F77_FUNC(clatrs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(clatrz)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work);
f77_ret_void F77_FUNC(clatzm)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *v, f77_integer CONST_REF incv, f77_complex *tau, f77_complex *c1, f77_complex *c2, f77_integer CONST_REF ldc, f77_complex *work);
f77_ret_void F77_FUNC(clauu2)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(clauum)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(cpbcon)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpbequ)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(cpbrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *afb, f77_integer CONST_REF ldafb, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpbstf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(cpbsv)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cpbsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *afb, f77_integer CONST_REF ldafb, const char *equed, f77_real *s, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpbtf2)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(cpbtrf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(cpbtrs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cpocon)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpoequ)(f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(cporfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cposv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cposvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, const char *equed, f77_real *s, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpotf2)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(cpotrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(cpotri)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(cpotrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cppcon)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cppequ)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(cpprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cppsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cppsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, const char *equed, f77_real *s, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpptrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *info);
f77_ret_void F77_FUNC(cpptri)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *info);
f77_ret_void F77_FUNC(cpptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cptcon)(f77_integer CONST_REF n, f77_real *d__, f77_complex *e, f77_real *anorm, f77_real *rcond, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cptrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_complex *e, f77_real *df, f77_complex *ef, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cptsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_complex *e, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cptsvx)(const char *fact, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_complex *e, f77_real *df, f77_complex *ef, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cpttrf)(f77_integer CONST_REF n, f77_real *d__, f77_complex *e, f77_integer *info);
f77_ret_void F77_FUNC(cpttrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_complex *e, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cptts2)(f77_integer *iuplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_complex *e, f77_complex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(crot)(f77_integer CONST_REF n, f77_complex *cx, f77_integer CONST_REF incx, f77_complex *cy, f77_integer CONST_REF incy, f77_real *c__, f77_complex *s);
f77_ret_void F77_FUNC(cspcon)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cspmv)(const char *uplo, f77_integer CONST_REF n, f77_complex *alpha, f77_complex *ap, f77_complex *x, f77_integer CONST_REF incx, f77_complex *beta, f77_complex *y, f77_integer CONST_REF incy);
f77_ret_void F77_FUNC(cspr)(const char *uplo, f77_integer CONST_REF n, f77_complex *alpha, f77_complex *x, f77_integer CONST_REF incx, f77_complex *ap);
f77_ret_void F77_FUNC(csprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(cspsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(cspsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *afp, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(csptrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(csptri)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_integer *ipiv, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(csptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(csrot)(f77_integer CONST_REF n, f77_complex *cx, f77_integer CONST_REF incx, f77_complex *cy, f77_integer CONST_REF incy, f77_real *c__, f77_real *s);
f77_ret_void F77_FUNC(csrscl)(f77_integer CONST_REF n, f77_real *sa, f77_complex *sx, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(cstedc)(const char *compz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_complex *z__, f77_integer CONST_REF ldz, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(cstein)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_integer CONST_REF m, f77_real *w, f77_integer *iblock, f77_integer *isplit, f77_complex *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(csteqr)(const char *compz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_complex *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(csycon)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(csymv)(const char *uplo, f77_integer CONST_REF n, f77_complex *alpha, f77_complex *a, f77_integer CONST_REF lda, f77_complex *x, f77_integer CONST_REF incx, f77_complex *beta, f77_complex *y, f77_integer CONST_REF incy);
f77_ret_void F77_FUNC(csyr)(const char *uplo, f77_integer CONST_REF n, f77_complex *alpha, f77_complex *x, f77_integer CONST_REF incx, f77_complex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(csyrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(csysv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(csysvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_complex *work, f77_integer CONST_REF lwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(csytf2)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(csytrf)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(csytri)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(csytrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ctbcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_complex *ab, f77_integer CONST_REF ldab, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctbrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctbtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_complex *ab, f77_integer CONST_REF ldab, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ctgevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctgex2)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *j1, f77_integer *info);
f77_ret_void F77_FUNC(ctgexc)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *ifst, f77_integer *ilst, f77_integer *info);
f77_ret_void F77_FUNC(ctgsen)(f77_integer *ijob, f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_logical *select, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *alpha, f77_complex *beta, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *z__, f77_integer CONST_REF ldz, f77_integer *m_out, f77_real *pl, f77_real *pr, f77_real *dif, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ctgsja)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_real *tola, f77_real *tolb, f77_real *alpha, f77_real *beta, f77_complex *u, f77_integer CONST_REF ldu, f77_complex *v, f77_integer CONST_REF ldv, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *work, f77_integer *ncycle, f77_integer *info);
f77_ret_void F77_FUNC(ctgsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_real *s, f77_real *dif, f77_integer *mm, f77_integer *m_out, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ctgsy2)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *d__, f77_integer CONST_REF ldd, f77_complex *e, f77_integer CONST_REF lde, f77_complex *f, f77_integer CONST_REF ldf, f77_real *scale, f77_real *rdsum, f77_real *rdscal, f77_integer *info);
f77_ret_void F77_FUNC(ctgsyl)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *d__, f77_integer CONST_REF ldd, f77_complex *e, f77_integer CONST_REF lde, f77_complex *f, f77_integer CONST_REF ldf, f77_real *scale, f77_real *dif, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ctpcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_complex *ap, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctprfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctptri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_complex *ap, f77_integer *info);
f77_ret_void F77_FUNC(ctptrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *ap, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ctrcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_real *rcond, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctrevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctrexc)(const char *compq, f77_integer CONST_REF n, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *q, f77_integer CONST_REF ldq, f77_integer *ifst, f77_integer *ilst, f77_integer *info);
f77_ret_void F77_FUNC(ctrrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_complex *work, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctrsen)(const char *job, const char *compq, f77_logical *select, f77_integer CONST_REF n, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *w, f77_integer *m_out, f77_real *s, f77_real *sep, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ctrsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_complex *t, f77_integer CONST_REF ldt, f77_complex *vl, f77_integer CONST_REF ldvl, f77_complex *vr, f77_integer CONST_REF ldvr, f77_real *s, f77_real *sep, f77_integer *mm, f77_integer *m_out, f77_complex *work, f77_integer CONST_REF ldwork, f77_real *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ctrsyl)(const char *trana, const char *tranb, f77_integer *isgn, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_complex *c__, f77_integer CONST_REF ldc, f77_real *scale, f77_integer *info);
f77_ret_void F77_FUNC(ctrti2)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(ctrtri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(ctrtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_complex *a, f77_integer CONST_REF lda, f77_complex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ctzrqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_integer *info);
f77_ret_void F77_FUNC(ctzrzf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cung2l)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cung2r)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cungbr)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunghr)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cungl2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunglq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cungql)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cungqr)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cungr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cungrq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cungtr)(const char *uplo, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunm2l)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunm2r)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunmbr)(const char *vect, const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmhr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunml2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunmlq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmql)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmqr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmr2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunmr3)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cunmrq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmrz)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cunmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *a, f77_integer CONST_REF lda, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(cupgtr)(const char *uplo, f77_integer CONST_REF n, f77_complex *ap, f77_complex *tau, f77_complex *q, f77_integer CONST_REF ldq, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(cupmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_complex *ap, f77_complex *tau, f77_complex *c__, f77_integer CONST_REF ldc, f77_complex *work, f77_integer *info);
f77_ret_void F77_FUNC(dbdsdc)(const char *uplo, const char *compq, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *q, f77_integer *iq, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dbdsqr)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_double *d__, f77_double *e, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *u, f77_integer CONST_REF ldu, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(ddisna)(const char *job, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *d__, f77_double *sep, f77_integer *info);
f77_ret_void F77_FUNC(dgbbrd)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF ncc, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_double *d__, f77_double *e, f77_double *q, f77_integer CONST_REF ldq, f77_double *pt, f77_integer CONST_REF ldpt, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgbcon)(const char *norm, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgbequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(dgbrfs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgbsv)(f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dgbsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, const char *equed, f77_double *r__, f77_double *c__, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgbtf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dgbtrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dgbtrs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dgebak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_integer CONST_REF m, f77_double *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(dgebal)(const char *job, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_integer *info);
f77_ret_void F77_FUNC(dgebd2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_double *tauq, f77_double *taup, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgebrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_double *tauq, f77_double *taup, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgecon)(const char *norm, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(dgees)(const char *jobvs, const char *sort, f77_logical_func select, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_double *wr, f77_double *wi, f77_double *vs, f77_integer CONST_REF ldvs, f77_double *work, f77_integer CONST_REF lwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeesx)(const char *jobvs, const char *sort, f77_logical_func select, const char *sense, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_double *wr, f77_double *wi, f77_double *vs, f77_integer CONST_REF ldvs, f77_double *rconde, f77_double *rcondv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *wr, f77_double *wi, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *wr, f77_double *wi, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_double *abnrm, f77_double *rconde, f77_double *rcondv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgegs)(const char *jobvsl, const char *jobvsr, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vsl, f77_integer CONST_REF ldvsl, f77_double *vsr, f77_integer CONST_REF ldvsr, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgegv)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgehd2)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgehrd)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgelq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgelqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgels)(const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgelsd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *s, f77_double *rcond, f77_integer *rank, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgelss)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *s, f77_double *rcond, f77_integer *rank, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgelsx)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_double *rcond, f77_integer *rank, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgelsy)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_double *rcond, f77_integer *rank, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeql2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgeqlf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeqp3)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgeqpf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgeqr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgeqrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgerfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgerq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgerqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgesc2)(f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *rhs, f77_integer *ipiv, f77_integer *jpiv, f77_double *scale);
f77_ret_void F77_FUNC(dgesdd)(const char *jobz, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *s, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgesv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dgesvd)(const char *jobu, const char *jobvt, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *s, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgesvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, const char *equed, f77_double *r__, f77_double *c__, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgetc2)(f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *jpiv, f77_integer *info);
f77_ret_void F77_FUNC(dgetf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dgetrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dgetri)(f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgetrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dggbak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_integer CONST_REF m, f77_double *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(dggbal)(const char *job, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgges)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func delctg, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vsl, f77_integer CONST_REF ldvsl, f77_double *vsr, f77_integer CONST_REF ldvsr, f77_double *work, f77_integer CONST_REF lwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(dggesx)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func delctg, const char *sense, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vsl, f77_integer CONST_REF ldvsl, f77_double *vsr, f77_integer CONST_REF ldvsr, f77_double *rconde, f77_double *rcondv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(dggev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dggevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_double *abnrm, f77_double *bbnrm, f77_double *rconde, f77_double *rcondv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(dggglm)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *d__, f77_double *x, f77_double *y, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dgghrd)(const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *q, f77_integer CONST_REF ldq, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(dgglse)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *c__, f77_double *d__, f77_double *x, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dggqrf)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_double *a, f77_integer CONST_REF lda, f77_double *taua, f77_double *b, f77_integer CONST_REF ldb, f77_double *taub, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dggrqf)(f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *taua, f77_double *b, f77_integer CONST_REF ldb, f77_double *taub, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dggsvd)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_integer CONST_REF k, f77_integer *l, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alpha, f77_double *beta, f77_double *u, f77_integer CONST_REF ldu, f77_double *v, f77_integer CONST_REF ldv, f77_double *q, f77_integer CONST_REF ldq, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dggsvp)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *tola, f77_double *tolb, f77_integer CONST_REF k, f77_integer *l, f77_double *u, f77_integer CONST_REF ldu, f77_double *v, f77_integer CONST_REF ldv, f77_double *q, f77_integer CONST_REF ldq, f77_integer *iwork, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dgtcon)(const char *norm, f77_integer CONST_REF n, f77_double *dl, f77_double *d__, f77_double *du, f77_double *du2, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgtrfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *dl, f77_double *d__, f77_double *du, f77_double *dlf, f77_double *df, f77_double *duf, f77_double *du2, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgtsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *dl, f77_double *d__, f77_double *du, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dgtsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *dl, f77_double *d__, f77_double *du, f77_double *dlf, f77_double *df, f77_double *duf, f77_double *du2, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dgttrf)(f77_integer CONST_REF n, f77_double *dl, f77_double *d__, f77_double *du, f77_double *du2, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dgttrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *dl, f77_double *d__, f77_double *du, f77_double *du2, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dgtts2)(f77_integer *itrans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *dl, f77_double *d__, f77_double *du, f77_double *du2, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(dhgeqz)(const char *job, const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *q, f77_integer CONST_REF ldq, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dhsein)(const char *side, const char *eigsrc, const char *initv, f77_logical *select, f77_integer CONST_REF n, f77_double *h__, f77_integer CONST_REF ldh, f77_double *wr, f77_double *wi, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_double *work, f77_integer *ifaill, f77_integer *ifailr, f77_integer *info);
f77_ret_void F77_FUNC(dhseqr)(const char *job, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *h__, f77_integer CONST_REF ldh, f77_double *wr, f77_double *wi, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dlabad)(f77_double *small, f77_double *large);
f77_ret_void F77_FUNC(dlabrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *nb, f77_double *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_double *tauq, f77_double *taup, f77_double *x, f77_integer CONST_REF ldx, f77_double *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(dlacon)(f77_integer CONST_REF n, f77_double *v, f77_double *x, f77_integer *isgn, f77_double *est, f77_integer *kase);
f77_ret_void F77_FUNC(dlacpy)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(dladiv)(f77_double *a, f77_double *b, f77_double *c__, f77_double *d__, f77_double *p, f77_double *q);
f77_ret_void F77_FUNC(dlae2)(f77_double *a, f77_double *b, f77_double *c__, f77_double *rt1, f77_double *rt2);
f77_ret_void F77_FUNC(dlaebz)(f77_integer *ijob, f77_integer *nitmax, f77_integer CONST_REF n, f77_integer *mmax, f77_integer *minp, f77_integer *nbmin, f77_double *abstol, f77_double *reltol, f77_double *pivmin, f77_double *d__, f77_double *e, f77_double *e2, f77_integer *nval, f77_double *ab, f77_double *c__, f77_integer *mout, f77_integer *nab, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlaed0)(f77_integer *icompq, f77_integer *qsiz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *q, f77_integer CONST_REF ldq, f77_double *qstore, f77_integer CONST_REF ldqs, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlaed1)(f77_integer CONST_REF n, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_double *rho, f77_integer *cutpnt, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlaed2)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *n1, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_double *rho, f77_double *z__, f77_double *dlamda, f77_double *w, f77_double *q2, f77_integer *indx, f77_integer *indxc, f77_integer *indxp, f77_integer *coltyp, f77_integer *info);
f77_ret_void F77_FUNC(dlaed3)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *n1, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_double *rho, f77_double *dlamda, f77_double *q2, f77_integer *indx, f77_integer *ctot, f77_double *w, f77_double *s, f77_integer *info);
f77_ret_void F77_FUNC(dlaed4)(f77_integer CONST_REF n, f77_integer *i__, f77_double *d__, f77_double *z__, f77_double *delta, f77_double *rho, f77_double *dlam, f77_integer *info);
f77_ret_void F77_FUNC(dlaed5)(f77_integer *i__, f77_double *d__, f77_double *z__, f77_double *delta, f77_double *rho, f77_double *dlam);
f77_ret_void F77_FUNC(dlaed6)(f77_integer *kniter, f77_logical *orgati, f77_double *rho, f77_double *d__, f77_double *z__, f77_double *finit, f77_double *tau, f77_integer *info);
f77_ret_void F77_FUNC(dlaed7)(f77_integer *icompq, f77_integer CONST_REF n, f77_integer *qsiz, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_double *rho, f77_integer *cutpnt, f77_double *qstore, f77_integer *qptr, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_double *givnum, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlaed8)(f77_integer *icompq, f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *qsiz, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_double *rho, f77_integer *cutpnt, f77_double *z__, f77_double *dlamda, f77_double *q2, f77_integer CONST_REF ldq2, f77_double *w, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_double *givnum, f77_integer *indxp, f77_integer *indx, f77_integer *info);
f77_ret_void F77_FUNC(dlaed9)(f77_integer CONST_REF k, f77_integer *kstart, f77_integer *kstop, f77_integer CONST_REF n, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_double *rho, f77_double *dlamda, f77_double *w, f77_double *s, f77_integer CONST_REF lds, f77_integer *info);
f77_ret_void F77_FUNC(dlaeda)(f77_integer CONST_REF n, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_double *givnum, f77_double *q, f77_integer *qptr, f77_double *z__, f77_double *ztemp, f77_integer *info);
f77_ret_void F77_FUNC(dlaein)(f77_logical *rightv, f77_logical *noinit, f77_integer CONST_REF n, f77_double *h__, f77_integer CONST_REF ldh, f77_double *wr, f77_double *wi, f77_double *vr, f77_double *vi, f77_double *b, f77_integer CONST_REF ldb, f77_double *work, f77_double *eps3, f77_double *smlnum, f77_double *bignum, f77_integer *info);
f77_ret_void F77_FUNC(dlaev2)(f77_double *a, f77_double *b, f77_double *c__, f77_double *rt1, f77_double *rt2, f77_double *cs1, f77_double *sn1);
f77_ret_void F77_FUNC(dlaexc)(f77_logical CONST_REF wantq, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *q, f77_integer CONST_REF ldq, f77_integer *j1, f77_integer *n1, f77_integer *n2, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlag2)(f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *safmin, f77_double *scale1, f77_double *scale2, f77_double *wr1, f77_double *wr2, f77_double *wi);
f77_ret_void F77_FUNC(dlags2)(f77_logical *upper, f77_double *a1, f77_double *a2, f77_double *a3, f77_double *b1, f77_double *b2, f77_double *b3, f77_double *csu, f77_double *snu, f77_double *csv, f77_double *snv, f77_double *csq, f77_double *snq);
f77_ret_void F77_FUNC(dlagtf)(f77_integer CONST_REF n, f77_double *a, f77_double *lambda, f77_double *b, f77_double *c__, f77_double *tol, f77_double *d__, f77_integer *in, f77_integer *info);
f77_ret_void F77_FUNC(dlagtm)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *alpha, f77_double *dl, f77_double *d__, f77_double *du, f77_double *x, f77_integer CONST_REF ldx, f77_double *beta, f77_double *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(dlagts)(f77_integer *job, f77_integer CONST_REF n, f77_double *a, f77_double *b, f77_double *c__, f77_double *d__, f77_integer *in, f77_double *y, f77_double *tol, f77_integer *info);
f77_ret_void F77_FUNC(dlagv2)(f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *csl, f77_double *snl, f77_double *csr, f77_double *snr);
f77_ret_void F77_FUNC(dlahqr)(f77_logical CONST_REF wantt, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *h__, f77_integer CONST_REF ldh, f77_double *wr, f77_double *wi, f77_integer *iloz, f77_integer *ihiz, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(dlahrd)(f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *nb, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *t, f77_integer CONST_REF ldt, f77_double *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(dlaic1)(f77_integer *job, f77_integer *j, f77_double *x, f77_double *sest, f77_double *w, f77_double *gamma, f77_double *sestpr, f77_double *s, f77_double *c__);
f77_ret_void F77_FUNC(dlaln2)(f77_logical *ltrans, f77_integer *na, f77_integer *nw, f77_double *smin, f77_double *ca, f77_double *a, f77_integer CONST_REF lda, f77_double *d1, f77_double *d2, f77_double *b, f77_integer CONST_REF ldb, f77_double *wr, f77_double *wi, f77_double *x, f77_integer CONST_REF ldx, f77_double *scale, f77_double *xnorm, f77_integer *info);
f77_ret_void F77_FUNC(dlals0)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF nrhs, f77_double *b, f77_integer CONST_REF ldb, f77_double *bx, f77_integer CONST_REF ldbx, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_double *givnum, f77_integer CONST_REF ldgnum, f77_double *poles, f77_double *difl, f77_double *difr, f77_double *z__, f77_integer CONST_REF k, f77_double *c__, f77_double *s, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlalsa)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *b, f77_integer CONST_REF ldb, f77_double *bx, f77_integer CONST_REF ldbx, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF k, f77_double *difl, f77_double *difr, f77_double *z__, f77_double *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_double *givnum, f77_double *c__, f77_double *s, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlalsd)(const char *uplo, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *b, f77_integer CONST_REF ldb, f77_double *rcond, f77_integer *rank, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlamc1)(f77_integer *beta, f77_integer *t, f77_logical *rnd, f77_logical *ieee1);
f77_ret_void F77_FUNC(dlamc2)(f77_integer *beta, f77_integer *t, f77_logical *rnd, f77_double *eps, f77_integer *emin, f77_double *rmin, f77_integer *emax, f77_double *rmax);
f77_ret_void F77_FUNC(dlamc4)(f77_integer *emin, f77_double *start, f77_integer *base);
f77_ret_void F77_FUNC(dlamc5)(f77_integer *beta, f77_integer CONST_REF p, f77_integer *emin, f77_logical *ieee, f77_integer *emax, f77_double *rmax);
f77_ret_void F77_FUNC(dlamrg)(f77_integer *n1, f77_integer *n2, f77_double *a, f77_integer *dtrd1, f77_integer *dtrd2, f77_integer *index);
f77_ret_void F77_FUNC(dlanv2)(f77_double *a, f77_double *b, f77_double *c__, f77_double *d__, f77_double *rt1r, f77_double *rt1i, f77_double *rt2r, f77_double *rt2i, f77_double *cs, f77_double *sn);
f77_ret_void F77_FUNC(dlapll)(f77_integer CONST_REF n, f77_double *x, f77_integer CONST_REF incx, f77_double *y, f77_integer CONST_REF incy, f77_double *ssmin);
f77_ret_void F77_FUNC(dlapmt)(f77_logical *forwrd, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *x, f77_integer CONST_REF ldx, f77_integer CONST_REF k);
f77_ret_void F77_FUNC(dlaqgb)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_double *ab, f77_integer CONST_REF ldab, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(dlaqge)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(dlaqp2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_double *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_double *tau, f77_double *vn1, f77_double *vn2, f77_double *work);
f77_ret_void F77_FUNC(dlaqps)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_integer *nb, f77_integer *kb, f77_double *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_double *tau, f77_double *vn1, f77_double *vn2, f77_double *auxv, f77_double *f, f77_integer CONST_REF ldf);
f77_ret_void F77_FUNC(dlaqsb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(dlaqsp)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(dlaqsy)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(dlaqtr)(f77_logical *ltran, f77_logical *lf77_real, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *b, f77_double *w, f77_double *scale, f77_double *x, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlar1v)(f77_integer CONST_REF n, f77_integer *b1, f77_integer *bn, f77_double *sigma, f77_double *d__, f77_double *l, f77_double *ld, f77_double *lld, f77_double *gersch, f77_double *z__, f77_double *ztz, f77_double *mingma, f77_integer *r__, f77_integer *isuppz, f77_double *work);
f77_ret_void F77_FUNC(dlar2v)(f77_integer CONST_REF n, f77_double *x, f77_double *y, f77_double *z__, f77_integer CONST_REF incx, f77_double *c__, f77_double *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(dlarf)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *v, f77_integer CONST_REF incv, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work);
f77_ret_void F77_FUNC(dlarfb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *v, f77_integer CONST_REF ldv, f77_double *t, f77_integer CONST_REF ldt, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(dlarfg)(f77_integer CONST_REF n, f77_double *alpha, f77_double *x, f77_integer CONST_REF incx, f77_double *tau);
f77_ret_void F77_FUNC(dlarft)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *v, f77_integer CONST_REF ldv, f77_double *tau, f77_double *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(dlarfx)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *v, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work);
f77_ret_void F77_FUNC(dlargv)(f77_integer CONST_REF n, f77_double *x, f77_integer CONST_REF incx, f77_double *y, f77_integer CONST_REF incy, f77_double *c__, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(dlarnv)(f77_integer *idist, f77_integer *iseed, f77_integer CONST_REF n, f77_double *x);
f77_ret_void F77_FUNC(dlarrb)(f77_integer CONST_REF n, f77_double *d__, f77_double *l, f77_double *ld, f77_double *lld, f77_integer *ifirst, f77_integer *ilast, f77_double *sigma, f77_double *reltol, f77_double *w, f77_double *wgap, f77_double *werr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlarre)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *tol, f77_integer *nsplit, f77_integer *isplit, f77_integer *m_out, f77_double *w, f77_double *woff, f77_double *gersch, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlarrf)(f77_integer CONST_REF n, f77_double *d__, f77_double *l, f77_double *ld, f77_double *lld, f77_integer *ifirst, f77_integer *ilast, f77_double *w, f77_double *dplus, f77_double *lplus, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlarrv)(f77_integer CONST_REF n, f77_double *d__, f77_double *l, f77_integer *isplit, f77_integer CONST_REF m, f77_double *w, f77_integer *iblock, f77_double *gersch, f77_double *tol, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlartg)(f77_double *f, f77_double *g, f77_double *cs, f77_double *sn, f77_double *r__);
f77_ret_void F77_FUNC(dlartv)(f77_integer CONST_REF n, f77_double *x, f77_integer CONST_REF incx, f77_double *y, f77_integer CONST_REF incy, f77_double *c__, f77_double *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(dlaruv)(f77_integer *iseed, f77_integer CONST_REF n, f77_double *x);
f77_ret_void F77_FUNC(dlarz)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_double *v, f77_integer CONST_REF incv, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work);
f77_ret_void F77_FUNC(dlarzb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_double *v, f77_integer CONST_REF ldv, f77_double *t, f77_integer CONST_REF ldt, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(dlarzt)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *v, f77_integer CONST_REF ldv, f77_double *tau, f77_double *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(dlas2)(f77_double *f, f77_double *g, f77_double *h__, f77_double *ssmin, f77_double *ssmax);
f77_ret_void F77_FUNC(dlascl)(const char *type__, f77_integer *kl, f77_integer *ku, f77_double *cfrom, f77_double *cto, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dlasd0)(f77_integer CONST_REF n, f77_integer *sqre, f77_double *d__, f77_double *e, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_integer *smlsiz, f77_integer *iwork, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasd1)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_double *d__, f77_double *alpha, f77_double *beta, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_integer *idxq, f77_integer *iwork, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasd2)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_double *d__, f77_double *z__, f77_double *alpha, f77_double *beta, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *dsigma, f77_double *u2, f77_integer CONST_REF ldu2, f77_double *vt2, f77_integer CONST_REF ldvt2, f77_integer *idxp, f77_integer *idx, f77_integer *idxc, f77_integer *idxq, f77_integer *coltyp, f77_integer *info);
f77_ret_void F77_FUNC(dlasd3)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_double *d__, f77_double *q, f77_integer CONST_REF ldq, f77_double *dsigma, f77_double *u, f77_integer CONST_REF ldu, f77_double *u2, f77_integer CONST_REF ldu2, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *vt2, f77_integer CONST_REF ldvt2, f77_integer *idxc, f77_integer *ctot, f77_double *z__, f77_integer *info);
f77_ret_void F77_FUNC(dlasd4)(f77_integer CONST_REF n, f77_integer *i__, f77_double *d__, f77_double *z__, f77_double *delta, f77_double *rho, f77_double *sigma, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasd5)(f77_integer *i__, f77_double *d__, f77_double *z__, f77_double *delta, f77_double *rho, f77_double *dsigma, f77_double *work);
f77_ret_void F77_FUNC(dlasd6)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_double *d__, f77_double *vf, f77_double *vl, f77_double *alpha, f77_double *beta, f77_integer *idxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_double *givnum, f77_integer CONST_REF ldgnum, f77_double *poles, f77_double *difl, f77_double *difr, f77_double *z__, f77_integer CONST_REF k, f77_double *c__, f77_double *s, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlasd7)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_double *d__, f77_double *z__, f77_double *zw, f77_double *vf, f77_double *vfw, f77_double *vl, f77_double *vlw, f77_double *alpha, f77_double *beta, f77_double *dsigma, f77_integer *idx, f77_integer *idxp, f77_integer *idxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_double *givnum, f77_integer CONST_REF ldgnum, f77_double *c__, f77_double *s, f77_integer *info);
f77_ret_void F77_FUNC(dlasd8)(f77_integer *icompq, f77_integer CONST_REF k, f77_double *d__, f77_double *z__, f77_double *vf, f77_double *vl, f77_double *difl, f77_double *difr, f77_integer CONST_REF lddifr, f77_double *dsigma, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasd9)(f77_integer *icompq, f77_integer CONST_REF ldu, f77_integer CONST_REF k, f77_double *d__, f77_double *z__, f77_double *vf, f77_double *vl, f77_double *difl, f77_double *difr, f77_double *dsigma, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasda)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer *sqre, f77_double *d__, f77_double *e, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF k, f77_double *difl, f77_double *difr, f77_double *z__, f77_double *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_double *givnum, f77_double *c__, f77_double *s, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dlasdq)(const char *uplo, f77_integer *sqre, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_double *d__, f77_double *e, f77_double *vt, f77_integer CONST_REF ldvt, f77_double *u, f77_integer CONST_REF ldu, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasdt)(f77_integer CONST_REF n, f77_integer *lvl, f77_integer *nd, f77_integer *inode, f77_integer *ndiml, f77_integer *ndimr, f77_integer *msub);
f77_ret_void F77_FUNC(dlaset)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *alpha, f77_double *beta, f77_double *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(dlasq1)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dlasq2)(f77_integer CONST_REF n, f77_double *z__, f77_integer *info);
f77_ret_void F77_FUNC(dlasq3)(f77_integer *i0, f77_integer *n0, f77_double *z__, f77_integer *pp, f77_double *dmin__, f77_double *sigma, f77_double *desig, f77_double *qmax, f77_integer *nfail, f77_integer *iter, f77_integer *ndiv, f77_logical *ieee);
f77_ret_void F77_FUNC(dlasq4)(f77_integer *i0, f77_integer *n0, f77_double *z__, f77_integer *pp, f77_integer *n0in, f77_double *dmin__, f77_double *dmin1, f77_double *dmin2, f77_double *dn, f77_double *dn1, f77_double *dn2, f77_double *tau, f77_integer *ttype);
f77_ret_void F77_FUNC(dlasq5)(f77_integer *i0, f77_integer *n0, f77_double *z__, f77_integer *pp, f77_double *tau, f77_double *dmin__, f77_double *dmin1, f77_double *dmin2, f77_double *dn, f77_double *dnm1, f77_double *dnm2, f77_logical *ieee);
f77_ret_void F77_FUNC(dlasq6)(f77_integer *i0, f77_integer *n0, f77_double *z__, f77_integer *pp, f77_double *dmin__, f77_double *dmin1, f77_double *dmin2, f77_double *dn, f77_double *dnm1, f77_double *dnm2);
f77_ret_void F77_FUNC(dlasr)(const char *side, const char *pivot, const char *direct, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *c__, f77_double *s, f77_double *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(dlasrt)(const char *id, f77_integer CONST_REF n, f77_double *d__, f77_integer *info);
f77_ret_void F77_FUNC(dlassq)(f77_integer CONST_REF n, f77_double *x, f77_integer CONST_REF incx, f77_double *scale, f77_double *sumsq);
f77_ret_void F77_FUNC(dlasv2)(f77_double *f, f77_double *g, f77_double *h__, f77_double *ssmin, f77_double *ssmax, f77_double *snr, f77_double *csr, f77_double *snl, f77_double *csl);
f77_ret_void F77_FUNC(dlaswp)(f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *k1, f77_integer *k2, f77_integer *ipiv, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(dlasy2)(f77_logical *ltranl, f77_logical *ltranr, f77_integer *isgn, f77_integer *n1, f77_integer *n2, f77_double *tl, f77_integer CONST_REF ldtl, f77_double *tr, f77_integer CONST_REF ldtr, f77_double *b, f77_integer CONST_REF ldb, f77_double *scale, f77_double *x, f77_integer CONST_REF ldx, f77_double *xnorm, f77_integer *info);
f77_ret_void F77_FUNC(dlasyf)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(dlatbs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(dlatdf)(f77_integer *ijob, f77_integer CONST_REF n, f77_double *z__, f77_integer CONST_REF ldz, f77_double *rhs, f77_double *rdsum, f77_double *rdscal, f77_integer *ipiv, f77_integer *jpiv);
f77_ret_void F77_FUNC(dlatps)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_double *ap, f77_double *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(dlatrd)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_double *a, f77_integer CONST_REF lda, f77_double *e, f77_double *tau, f77_double *w, f77_integer CONST_REF ldw);
f77_ret_void F77_FUNC(dlatrs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(dlatrz)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work);
f77_ret_void F77_FUNC(dlatzm)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *v, f77_integer CONST_REF incv, f77_double *tau, f77_double *c1, f77_double *c2, f77_integer CONST_REF ldc, f77_double *work);
f77_ret_void F77_FUNC(dlauu2)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dlauum)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dopgtr)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *tau, f77_double *q, f77_integer CONST_REF ldq, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dopmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *ap, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorg2l)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorg2r)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorgbr)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorghr)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorgl2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorglq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorgql)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorgqr)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorgr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorgrq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorgtr)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorm2l)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dorm2r)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dormbr)(const char *vect, const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormhr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dorml2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dormlq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormql)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormqr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormr2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dormr3)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dormrq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormrz)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dormtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *c__, f77_integer CONST_REF ldc, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dpbcon)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpbequ)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(dpbrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *afb, f77_integer CONST_REF ldafb, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpbstf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(dpbsv)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dpbsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *afb, f77_integer CONST_REF ldafb, const char *equed, f77_double *s, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpbtf2)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(dpbtrf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(dpbtrs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dpocon)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpoequ)(f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(dporfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dposv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dposvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, const char *equed, f77_double *s, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpotf2)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dpotrf)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dpotri)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dpotrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dppcon)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dppequ)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(dpprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *afp, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dppsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dppsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *afp, const char *equed, f77_double *s, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dpptrf)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_integer *info);
f77_ret_void F77_FUNC(dpptri)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_integer *info);
f77_ret_void F77_FUNC(dpptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dptcon)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dpteqr)(const char *compz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dptrfs)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *df, f77_double *ef, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dptsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dptsvx)(const char *fact, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *df, f77_double *ef, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dpttrf)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_integer *info);
f77_ret_void F77_FUNC(dpttrs)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dptts2)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_double *e, f77_double *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(drscl)(f77_integer CONST_REF n, f77_double *sa, f77_double *sx, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(dsbev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsbevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dsbevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *q, f77_integer CONST_REF ldq, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsbgst)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_double *ab, f77_integer CONST_REF ldab, f77_double *bb, f77_integer CONST_REF ldbb, f77_double *x, f77_integer CONST_REF ldx, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsbgv)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_double *ab, f77_integer CONST_REF ldab, f77_double *bb, f77_integer CONST_REF ldbb, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsbgvd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_double *ab, f77_integer CONST_REF ldab, f77_double *bb, f77_integer CONST_REF ldbb, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dsbgvx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_double *ab, f77_integer CONST_REF ldab, f77_double *bb, f77_integer CONST_REF ldbb, f77_double *q, f77_integer CONST_REF ldq, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsbtrd)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *d__, f77_double *e, f77_double *q, f77_integer CONST_REF ldq, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dspcon)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dspev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dspevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dspevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dspgst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *bp, f77_integer *info);
f77_ret_void F77_FUNC(dspgv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *bp, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dspgvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *bp, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dspgvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *bp, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *afp, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dspsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dspsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *afp, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dsptrd)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_double *d__, f77_double *e, f77_double *tau, f77_integer *info);
f77_ret_void F77_FUNC(dsptrf)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dsptri)(const char *uplo, f77_integer CONST_REF n, f77_double *ap, f77_integer *ipiv, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dstebz)(const char *range, const char *order, f77_integer CONST_REF n, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_double *d__, f77_double *e, f77_integer *m_out, f77_integer *nsplit, f77_double *w, f77_integer *iblock, f77_integer *isplit, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dstedc)(const char *compz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dstegr)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dstein)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_integer CONST_REF m, f77_double *w, f77_integer *iblock, f77_integer *isplit, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsteqr)(const char *compz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsterf)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_integer *info);
f77_ret_void F77_FUNC(dstev)(const char *jobz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dstevd)(const char *jobz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dstevr)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dstevx)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsycon)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dsyev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *w, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dsyevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *w, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dsyevr)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dsyevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsygs2)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dsygst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dsygv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *w, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dsygvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *w, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dsygvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_double *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(dsyrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dsysv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dsysvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dsytd2)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_double *tau, f77_integer *info);
f77_ret_void F77_FUNC(dsytf2)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(dsytrd)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dsytrf)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dsytri)(const char *uplo, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dsytrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dtbcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_double *ab, f77_integer CONST_REF ldab, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtbrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtbtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_double *ab, f77_integer CONST_REF ldab, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dtgevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dtgex2)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *q, f77_integer CONST_REF ldq, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *j1, f77_integer *n1, f77_integer *n2, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dtgexc)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *q, f77_integer CONST_REF ldq, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *ifst, f77_integer *ilst, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(dtgsen)(f77_integer *ijob, f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_logical *select, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *alphar, f77_double *alphai, f77_double *beta, f77_double *q, f77_integer CONST_REF ldq, f77_double *z__, f77_integer CONST_REF ldz, f77_integer *m_out, f77_double *pl, f77_double *pr, f77_double *dif, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dtgsja)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *tola, f77_double *tolb, f77_double *alpha, f77_double *beta, f77_double *u, f77_integer CONST_REF ldu, f77_double *v, f77_integer CONST_REF ldv, f77_double *q, f77_integer CONST_REF ldq, f77_double *work, f77_integer *ncycle, f77_integer *info);
f77_ret_void F77_FUNC(dtgsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_double *s, f77_double *dif, f77_integer *mm, f77_integer *m_out, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtgsy2)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *c__, f77_integer CONST_REF ldc, f77_double *d__, f77_integer CONST_REF ldd, f77_double *e, f77_integer CONST_REF lde, f77_double *f, f77_integer CONST_REF ldf, f77_double *scale, f77_double *rdsum, f77_double *rdscal, f77_integer *iwork, f77_integer *pq, f77_integer *info);
f77_ret_void F77_FUNC(dtgsyl)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *c__, f77_integer CONST_REF ldc, f77_double *d__, f77_integer CONST_REF ldd, f77_double *e, f77_integer CONST_REF lde, f77_double *f, f77_integer CONST_REF ldf, f77_double *scale, f77_double *dif, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtpcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_double *ap, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtprfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtptri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_double *ap, f77_integer *info);
f77_ret_void F77_FUNC(dtptrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *ap, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dtrcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *rcond, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtrevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dtrexc)(const char *compq, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *q, f77_integer CONST_REF ldq, f77_integer *ifst, f77_integer *ilst, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(dtrrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtrsen)(const char *job, const char *compq, f77_logical *select, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *q, f77_integer CONST_REF ldq, f77_double *wr, f77_double *wi, f77_integer *m_out, f77_double *s, f77_double *sep, f77_double *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(dtrsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_double *t, f77_integer CONST_REF ldt, f77_double *vl, f77_integer CONST_REF ldvl, f77_double *vr, f77_integer CONST_REF ldvr, f77_double *s, f77_double *sep, f77_integer *mm, f77_integer *m_out, f77_double *work, f77_integer CONST_REF ldwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(dtrsyl)(const char *trana, const char *tranb, f77_integer *isgn, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_double *c__, f77_integer CONST_REF ldc, f77_double *scale, f77_integer *info);
f77_ret_void F77_FUNC(dtrti2)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dtrtri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(dtrtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(dtzrqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_integer *info);
f77_ret_void F77_FUNC(dtzrzf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_double *tau, f77_double *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_integer F77_FUNC(icmax1)(f77_integer CONST_REF n, f77_complex *cx, f77_integer CONST_REF incx);
f77_ret_integer F77_FUNC(ieeeck)(f77_integer CONST_REF ispec, f77_real *zero, f77_real *one);
f77_ret_integer F77_FUNC(ilaenv)(f77_integer CONST_REF ispec, const char *name__, const char *opts, f77_integer *n1, f77_integer *n2, f77_integer *n3, f77_integer *n4, f77_str_len name_len, f77_str_len opts_len);
f77_ret_integer F77_FUNC(izmax1)(f77_integer CONST_REF n, f77_doublecomplex *cx, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(sbdsdc)(const char *uplo, const char *compq, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *q, f77_integer *iq, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sbdsqr)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_real *d__, f77_real *e, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *u, f77_integer CONST_REF ldu, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sdisna)(const char *job, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *d__, f77_real *sep, f77_integer *info);
f77_ret_void F77_FUNC(sgbbrd)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF ncc, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_real *d__, f77_real *e, f77_real *q, f77_integer CONST_REF ldq, f77_real *pt, f77_integer CONST_REF ldpt, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgbcon)(const char *norm, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgbequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(sgbrfs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgbsv)(f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sgbsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, const char *equed, f77_real *r__, f77_real *c__, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgbtf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(sgbtrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(sgbtrs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sgebak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_integer CONST_REF m, f77_real *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(sgebal)(const char *job, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_integer *info);
f77_ret_void F77_FUNC(sgebd2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_real *tauq, f77_real *taup, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgebrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_real *tauq, f77_real *taup, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgecon)(const char *norm, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(sgees)(const char *jobvs, const char *sort, f77_logical_func select, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_real *wr, f77_real *wi, f77_real *vs, f77_integer CONST_REF ldvs, f77_real *work, f77_integer CONST_REF lwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeesx)(const char *jobvs, const char *sort, f77_logical_func select, const char *sense, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_real *wr, f77_real *wi, f77_real *vs, f77_integer CONST_REF ldvs, f77_real *rconde, f77_real *rcondv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *wr, f77_real *wi, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *wr, f77_real *wi, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_real *scale, f77_real *abnrm, f77_real *rconde, f77_real *rcondv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgegs)(const char *jobvsl, const char *jobvsr, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vsl, f77_integer CONST_REF ldvsl, f77_real *vsr, f77_integer CONST_REF ldvsr, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgegv)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgehd2)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgehrd)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgelq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgelqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgels)(const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgelsd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *s, f77_real *rcond, f77_integer *rank, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgelss)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *s, f77_real *rcond, f77_integer *rank, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgelsx)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_real *rcond, f77_integer *rank, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgelsy)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_real *rcond, f77_integer *rank, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeql2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgeqlf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeqp3)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgeqpf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgeqr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgeqrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgerfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgerq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgerqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgesc2)(f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *rhs, f77_integer *ipiv, f77_integer *jpiv, f77_real *scale);
f77_ret_void F77_FUNC(sgesdd)(const char *jobz, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *s, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgesv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sgesvd)(const char *jobu, const char *jobvt, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *s, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgesvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, const char *equed, f77_real *r__, f77_real *c__, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgetc2)(f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *jpiv, f77_integer *info);
f77_ret_void F77_FUNC(sgetf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(sgetrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(sgetri)(f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgetrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sggbak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_integer CONST_REF m, f77_real *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(sggbal)(const char *job, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgges)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func selctg, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vsl, f77_integer CONST_REF ldvsl, f77_real *vsr, f77_integer CONST_REF ldvsr, f77_real *work, f77_integer CONST_REF lwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(sggesx)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func selctg, const char *sense, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vsl, f77_integer CONST_REF ldvsl, f77_real *vsr, f77_integer CONST_REF ldvsr, f77_real *rconde, f77_real *rcondv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(sggev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sggevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_real *lscale, f77_real *rscale, f77_real *abnrm, f77_real *bbnrm, f77_real *rconde, f77_real *rcondv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(sggglm)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *d__, f77_real *x, f77_real *y, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sgghrd)(const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *q, f77_integer CONST_REF ldq, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(sgglse)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *c__, f77_real *d__, f77_real *x, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sggqrf)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_real *a, f77_integer CONST_REF lda, f77_real *taua, f77_real *b, f77_integer CONST_REF ldb, f77_real *taub, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sggrqf)(f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *taua, f77_real *b, f77_integer CONST_REF ldb, f77_real *taub, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sggsvd)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_integer CONST_REF k, f77_integer *l, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alpha, f77_real *beta, f77_real *u, f77_integer CONST_REF ldu, f77_real *v, f77_integer CONST_REF ldv, f77_real *q, f77_integer CONST_REF ldq, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sggsvp)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *tola, f77_real *tolb, f77_integer CONST_REF k, f77_integer *l, f77_real *u, f77_integer CONST_REF ldu, f77_real *v, f77_integer CONST_REF ldv, f77_real *q, f77_integer CONST_REF ldq, f77_integer *iwork, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sgtcon)(const char *norm, f77_integer CONST_REF n, f77_real *dl, f77_real *d__, f77_real *du, f77_real *du2, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgtrfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *dl, f77_real *d__, f77_real *du, f77_real *dlf, f77_real *df, f77_real *duf, f77_real *du2, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgtsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *dl, f77_real *d__, f77_real *du, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sgtsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *dl, f77_real *d__, f77_real *du, f77_real *dlf, f77_real *df, f77_real *duf, f77_real *du2, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sgttrf)(f77_integer CONST_REF n, f77_real *dl, f77_real *d__, f77_real *du, f77_real *du2, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(sgttrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *dl, f77_real *d__, f77_real *du, f77_real *du2, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sgtts2)(f77_integer *itrans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *dl, f77_real *d__, f77_real *du, f77_real *du2, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(shgeqz)(const char *job, const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *q, f77_integer CONST_REF ldq, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(shsein)(const char *side, const char *eigsrc, const char *initv, f77_logical *select, f77_integer CONST_REF n, f77_real *h__, f77_integer CONST_REF ldh, f77_real *wr, f77_real *wi, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_real *work, f77_integer *ifaill, f77_integer *ifailr, f77_integer *info);
f77_ret_void F77_FUNC(shseqr)(const char *job, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *h__, f77_integer CONST_REF ldh, f77_real *wr, f77_real *wi, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(slabad)(f77_real *small, f77_real *large);
f77_ret_void F77_FUNC(slabrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *nb, f77_real *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_real *tauq, f77_real *taup, f77_real *x, f77_integer CONST_REF ldx, f77_real *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(slacon)(f77_integer CONST_REF n, f77_real *v, f77_real *x, f77_integer *isgn, f77_real *est, f77_integer *kase);
f77_ret_void F77_FUNC(slacpy)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(sladiv)(f77_real *a, f77_real *b, f77_real *c__, f77_real *d__, f77_real *p, f77_real *q);
f77_ret_void F77_FUNC(slae2)(f77_real *a, f77_real *b, f77_real *c__, f77_real *rt1, f77_real *rt2);
f77_ret_void F77_FUNC(slaebz)(f77_integer *ijob, f77_integer *nitmax, f77_integer CONST_REF n, f77_integer *mmax, f77_integer *minp, f77_integer *nbmin, f77_real *abstol, f77_real *reltol, f77_real *pivmin, f77_real *d__, f77_real *e, f77_real *e2, f77_integer *nval, f77_real *ab, f77_real *c__, f77_integer *mout, f77_integer *nab, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slaed0)(f77_integer *icompq, f77_integer *qsiz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *q, f77_integer CONST_REF ldq, f77_real *qstore, f77_integer CONST_REF ldqs, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slaed1)(f77_integer CONST_REF n, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_real *rho, f77_integer *cutpnt, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slaed2)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *n1, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_real *rho, f77_real *z__, f77_real *dlamda, f77_real *w, f77_real *q2, f77_integer *indx, f77_integer *indxc, f77_integer *indxp, f77_integer *coltyp, f77_integer *info);
f77_ret_void F77_FUNC(slaed3)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *n1, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_real *rho, f77_real *dlamda, f77_real *q2, f77_integer *indx, f77_integer *ctot, f77_real *w, f77_real *s, f77_integer *info);
f77_ret_void F77_FUNC(slaed4)(f77_integer CONST_REF n, f77_integer *i__, f77_real *d__, f77_real *z__, f77_real *delta, f77_real *rho, f77_real *dlam, f77_integer *info);
f77_ret_void F77_FUNC(slaed5)(f77_integer *i__, f77_real *d__, f77_real *z__, f77_real *delta, f77_real *rho, f77_real *dlam);
f77_ret_void F77_FUNC(slaed6)(f77_integer *kniter, f77_logical *orgati, f77_real *rho, f77_real *d__, f77_real *z__, f77_real *finit, f77_real *tau, f77_integer *info);
f77_ret_void F77_FUNC(slaed7)(f77_integer *icompq, f77_integer CONST_REF n, f77_integer *qsiz, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_real *rho, f77_integer *cutpnt, f77_real *qstore, f77_integer *qptr, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_real *givnum, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slaed8)(f77_integer *icompq, f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *qsiz, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_integer *indxq, f77_real *rho, f77_integer *cutpnt, f77_real *z__, f77_real *dlamda, f77_real *q2, f77_integer CONST_REF ldq2, f77_real *w, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_real *givnum, f77_integer *indxp, f77_integer *indx, f77_integer *info);
f77_ret_void F77_FUNC(slaed9)(f77_integer CONST_REF k, f77_integer *kstart, f77_integer *kstop, f77_integer CONST_REF n, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_real *rho, f77_real *dlamda, f77_real *w, f77_real *s, f77_integer CONST_REF lds, f77_integer *info);
f77_ret_void F77_FUNC(slaeda)(f77_integer CONST_REF n, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_real *givnum, f77_real *q, f77_integer *qptr, f77_real *z__, f77_real *ztemp, f77_integer *info);
f77_ret_void F77_FUNC(slaein)(f77_logical *rightv, f77_logical *noinit, f77_integer CONST_REF n, f77_real *h__, f77_integer CONST_REF ldh, f77_real *wr, f77_real *wi, f77_real *vr, f77_real *vi, f77_real *b, f77_integer CONST_REF ldb, f77_real *work, f77_real *eps3, f77_real *smlnum, f77_real *bignum, f77_integer *info);
f77_ret_void F77_FUNC(slaev2)(f77_real *a, f77_real *b, f77_real *c__, f77_real *rt1, f77_real *rt2, f77_real *cs1, f77_real *sn1);
f77_ret_void F77_FUNC(slaexc)(f77_logical CONST_REF wantq, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *q, f77_integer CONST_REF ldq, f77_integer *j1, f77_integer *n1, f77_integer *n2, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slag2)(f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *safmin, f77_real *scale1, f77_real *scale2, f77_real *wr1, f77_real *wr2, f77_real *wi);
f77_ret_void F77_FUNC(slags2)(f77_logical *upper, f77_real *a1, f77_real *a2, f77_real *a3, f77_real *b1, f77_real *b2, f77_real *b3, f77_real *csu, f77_real *snu, f77_real *csv, f77_real *snv, f77_real *csq, f77_real *snq);
f77_ret_void F77_FUNC(slagtf)(f77_integer CONST_REF n, f77_real *a, f77_real *lambda, f77_real *b, f77_real *c__, f77_real *tol, f77_real *d__, f77_integer *in, f77_integer *info);
f77_ret_void F77_FUNC(slagtm)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *alpha, f77_real *dl, f77_real *d__, f77_real *du, f77_real *x, f77_integer CONST_REF ldx, f77_real *beta, f77_real *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(slagts)(f77_integer *job, f77_integer CONST_REF n, f77_real *a, f77_real *b, f77_real *c__, f77_real *d__, f77_integer *in, f77_real *y, f77_real *tol, f77_integer *info);
f77_ret_void F77_FUNC(slagv2)(f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *csl, f77_real *snl, f77_real *csr, f77_real *snr);
f77_ret_void F77_FUNC(slahqr)(f77_logical CONST_REF wantt, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *h__, f77_integer CONST_REF ldh, f77_real *wr, f77_real *wi, f77_integer *iloz, f77_integer *ihiz, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(slahrd)(f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *nb, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *t, f77_integer CONST_REF ldt, f77_real *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(slaic1)(f77_integer *job, f77_integer *j, f77_real *x, f77_real *sest, f77_real *w, f77_real *gamma, f77_real *sestpr, f77_real *s, f77_real *c__);
f77_ret_void F77_FUNC(slaln2)(f77_logical *ltrans, f77_integer *na, f77_integer *nw, f77_real *smin, f77_real *ca, f77_real *a, f77_integer CONST_REF lda, f77_real *d1, f77_real *d2, f77_real *b, f77_integer CONST_REF ldb, f77_real *wr, f77_real *wi, f77_real *x, f77_integer CONST_REF ldx, f77_real *scale, f77_real *xnorm, f77_integer *info);
f77_ret_void F77_FUNC(slals0)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF nrhs, f77_real *b, f77_integer CONST_REF ldb, f77_real *bx, f77_integer CONST_REF ldbx, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_real *givnum, f77_integer CONST_REF ldgnum, f77_real *poles, f77_real *difl, f77_real *difr, f77_real *z__, f77_integer CONST_REF k, f77_real *c__, f77_real *s, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slalsa)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *b, f77_integer CONST_REF ldb, f77_real *bx, f77_integer CONST_REF ldbx, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF k, f77_real *difl, f77_real *difr, f77_real *z__, f77_real *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_real *givnum, f77_real *c__, f77_real *s, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slalsd)(const char *uplo, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *b, f77_integer CONST_REF ldb, f77_real *rcond, f77_integer *rank, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slamc1)(f77_integer *beta, f77_integer *t, f77_logical *rnd, f77_logical *ieee1);
f77_ret_void F77_FUNC(slamc2)(f77_integer *beta, f77_integer *t, f77_logical *rnd, f77_real *eps, f77_integer *emin, f77_real *rmin, f77_integer *emax, f77_real *rmax);
f77_ret_void F77_FUNC(slamc4)(f77_integer *emin, f77_real *start, f77_integer *base);
f77_ret_void F77_FUNC(slamc5)(f77_integer *beta, f77_integer CONST_REF p, f77_integer *emin, f77_logical *ieee, f77_integer *emax, f77_real *rmax);
f77_ret_void F77_FUNC(slamrg)(f77_integer *n1, f77_integer *n2, f77_real *a, f77_integer *strd1, f77_integer *strd2, f77_integer *index);
f77_ret_void F77_FUNC(slanv2)(f77_real *a, f77_real *b, f77_real *c__, f77_real *d__, f77_real *rt1r, f77_real *rt1i, f77_real *rt2r, f77_real *rt2i, f77_real *cs, f77_real *sn);
f77_ret_void F77_FUNC(slapll)(f77_integer CONST_REF n, f77_real *x, f77_integer CONST_REF incx, f77_real *y, f77_integer CONST_REF incy, f77_real *ssmin);
f77_ret_void F77_FUNC(slapmt)(f77_logical *forwrd, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *x, f77_integer CONST_REF ldx, f77_integer CONST_REF k);
f77_ret_void F77_FUNC(slaqgb)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_real *ab, f77_integer CONST_REF ldab, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(slaqge)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *r__, f77_real *c__, f77_real *rowcnd, f77_real *colcnd, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(slaqp2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_real *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_real *tau, f77_real *vn1, f77_real *vn2, f77_real *work);
f77_ret_void F77_FUNC(slaqps)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_integer *nb, f77_integer *kb, f77_real *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_real *tau, f77_real *vn1, f77_real *vn2, f77_real *auxv, f77_real *f, f77_integer CONST_REF ldf);
f77_ret_void F77_FUNC(slaqsb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(slaqsp)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(slaqsy)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *s, f77_real *scond, f77_real *amax, const char *equed);
f77_ret_void F77_FUNC(slaqtr)(f77_logical *ltran, f77_logical *lf77_real, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *b, f77_real *w, f77_real *scale, f77_real *x, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slar1v)(f77_integer CONST_REF n, f77_integer *b1, f77_integer *bn, f77_real *sigma, f77_real *d__, f77_real *l, f77_real *ld, f77_real *lld, f77_real *gersch, f77_real *z__, f77_real *ztz, f77_real *mingma, f77_integer *r__, f77_integer *isuppz, f77_real *work);
f77_ret_void F77_FUNC(slar2v)(f77_integer CONST_REF n, f77_real *x, f77_real *y, f77_real *z__, f77_integer CONST_REF incx, f77_real *c__, f77_real *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(slarf)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *v, f77_integer CONST_REF incv, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work);
f77_ret_void F77_FUNC(slarfb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *v, f77_integer CONST_REF ldv, f77_real *t, f77_integer CONST_REF ldt, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(slarfg)(f77_integer CONST_REF n, f77_real *alpha, f77_real *x, f77_integer CONST_REF incx, f77_real *tau);
f77_ret_void F77_FUNC(slarft)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *v, f77_integer CONST_REF ldv, f77_real *tau, f77_real *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(slarfx)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *v, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work);
f77_ret_void F77_FUNC(slargv)(f77_integer CONST_REF n, f77_real *x, f77_integer CONST_REF incx, f77_real *y, f77_integer CONST_REF incy, f77_real *c__, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(slarnv)(f77_integer *idist, f77_integer *iseed, f77_integer CONST_REF n, f77_real *x);
f77_ret_void F77_FUNC(slarrb)(f77_integer CONST_REF n, f77_real *d__, f77_real *l, f77_real *ld, f77_real *lld, f77_integer *ifirst, f77_integer *ilast, f77_real *sigma, f77_real *reltol, f77_real *w, f77_real *wgap, f77_real *werr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slarre)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *tol, f77_integer *nsplit, f77_integer *isplit, f77_integer *m_out, f77_real *w, f77_real *woff, f77_real *gersch, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slarrf)(f77_integer CONST_REF n, f77_real *d__, f77_real *l, f77_real *ld, f77_real *lld, f77_integer *ifirst, f77_integer *ilast, f77_real *w, f77_real *dplus, f77_real *lplus, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slarrv)(f77_integer CONST_REF n, f77_real *d__, f77_real *l, f77_integer *isplit, f77_integer CONST_REF m, f77_real *w, f77_integer *iblock, f77_real *gersch, f77_real *tol, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slartg)(f77_real *f, f77_real *g, f77_real *cs, f77_real *sn, f77_real *r__);
f77_ret_void F77_FUNC(slartv)(f77_integer CONST_REF n, f77_real *x, f77_integer CONST_REF incx, f77_real *y, f77_integer CONST_REF incy, f77_real *c__, f77_real *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(slaruv)(f77_integer *iseed, f77_integer CONST_REF n, f77_real *x);
f77_ret_void F77_FUNC(slarz)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_real *v, f77_integer CONST_REF incv, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work);
f77_ret_void F77_FUNC(slarzb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_real *v, f77_integer CONST_REF ldv, f77_real *t, f77_integer CONST_REF ldt, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(slarzt)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *v, f77_integer CONST_REF ldv, f77_real *tau, f77_real *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(slas2)(f77_real *f, f77_real *g, f77_real *h__, f77_real *ssmin, f77_real *ssmax);
f77_ret_void F77_FUNC(slascl)(const char *type__, f77_integer *kl, f77_integer *ku, f77_real *cfrom, f77_real *cto, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(slasd0)(f77_integer CONST_REF n, f77_integer *sqre, f77_real *d__, f77_real *e, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_integer *smlsiz, f77_integer *iwork, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasd1)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_real *d__, f77_real *alpha, f77_real *beta, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_integer *idxq, f77_integer *iwork, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasd2)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_real *d__, f77_real *z__, f77_real *alpha, f77_real *beta, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *dsigma, f77_real *u2, f77_integer CONST_REF ldu2, f77_real *vt2, f77_integer CONST_REF ldvt2, f77_integer *idxp, f77_integer *idx, f77_integer *idxc, f77_integer *idxq, f77_integer *coltyp, f77_integer *info);
f77_ret_void F77_FUNC(slasd3)(f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_real *d__, f77_real *q, f77_integer CONST_REF ldq, f77_real *dsigma, f77_real *u, f77_integer CONST_REF ldu, f77_real *u2, f77_integer CONST_REF ldu2, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *vt2, f77_integer CONST_REF ldvt2, f77_integer *idxc, f77_integer *ctot, f77_real *z__, f77_integer *info);
f77_ret_void F77_FUNC(slasd4)(f77_integer CONST_REF n, f77_integer *i__, f77_real *d__, f77_real *z__, f77_real *delta, f77_real *rho, f77_real *sigma, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasd5)(f77_integer *i__, f77_real *d__, f77_real *z__, f77_real *delta, f77_real *rho, f77_real *dsigma, f77_real *work);
f77_ret_void F77_FUNC(slasd6)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_real *d__, f77_real *vf, f77_real *vl, f77_real *alpha, f77_real *beta, f77_integer *idxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_real *givnum, f77_integer CONST_REF ldgnum, f77_real *poles, f77_real *difl, f77_real *difr, f77_real *z__, f77_integer CONST_REF k, f77_real *c__, f77_real *s, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slasd7)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF k, f77_real *d__, f77_real *z__, f77_real *zw, f77_real *vf, f77_real *vfw, f77_real *vl, f77_real *vlw, f77_real *alpha, f77_real *beta, f77_real *dsigma, f77_integer *idx, f77_integer *idxp, f77_integer *idxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_real *givnum, f77_integer CONST_REF ldgnum, f77_real *c__, f77_real *s, f77_integer *info);
f77_ret_void F77_FUNC(slasd8)(f77_integer *icompq, f77_integer CONST_REF k, f77_real *d__, f77_real *z__, f77_real *vf, f77_real *vl, f77_real *difl, f77_real *difr, f77_integer CONST_REF lddifr, f77_real *dsigma, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasd9)(f77_integer *icompq, f77_integer CONST_REF ldu, f77_integer CONST_REF k, f77_real *d__, f77_real *z__, f77_real *vf, f77_real *vl, f77_real *difl, f77_real *difr, f77_real *dsigma, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasda)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer *sqre, f77_real *d__, f77_real *e, f77_real *u, f77_integer CONST_REF ldu, f77_real *vt, f77_integer CONST_REF k, f77_real *difl, f77_real *difr, f77_real *z__, f77_real *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_real *givnum, f77_real *c__, f77_real *s, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(slasdq)(const char *uplo, f77_integer *sqre, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_real *d__, f77_real *e, f77_real *vt, f77_integer CONST_REF ldvt, f77_real *u, f77_integer CONST_REF ldu, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasdt)(f77_integer CONST_REF n, f77_integer *lvl, f77_integer *nd, f77_integer *inode, f77_integer *ndiml, f77_integer *ndimr, f77_integer *msub);
f77_ret_void F77_FUNC(slaset)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *alpha, f77_real *beta, f77_real *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(slasq1)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(slasq2)(f77_integer CONST_REF n, f77_real *z__, f77_integer *info);
f77_ret_void F77_FUNC(slasq3)(f77_integer *i0, f77_integer *n0, f77_real *z__, f77_integer *pp, f77_real *dmin__, f77_real *sigma, f77_real *desig, f77_real *qmax, f77_integer *nfail, f77_integer *iter, f77_integer *ndiv, f77_logical *ieee);
f77_ret_void F77_FUNC(slasq4)(f77_integer *i0, f77_integer *n0, f77_real *z__, f77_integer *pp, f77_integer *n0in, f77_real *dmin__, f77_real *dmin1, f77_real *dmin2, f77_real *dn, f77_real *dn1, f77_real *dn2, f77_real *tau, f77_integer *ttype);
f77_ret_void F77_FUNC(slasq5)(f77_integer *i0, f77_integer *n0, f77_real *z__, f77_integer *pp, f77_real *tau, f77_real *dmin__, f77_real *dmin1, f77_real *dmin2, f77_real *dn, f77_real *dnm1, f77_real *dnm2, f77_logical *ieee);
f77_ret_void F77_FUNC(slasq6)(f77_integer *i0, f77_integer *n0, f77_real *z__, f77_integer *pp, f77_real *dmin__, f77_real *dmin1, f77_real *dmin2, f77_real *dn, f77_real *dnm1, f77_real *dnm2);
f77_ret_void F77_FUNC(slasr)(const char *side, const char *pivot, const char *direct, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *c__, f77_real *s, f77_real *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(slasrt)(const char *id, f77_integer CONST_REF n, f77_real *d__, f77_integer *info);
f77_ret_void F77_FUNC(slassq)(f77_integer CONST_REF n, f77_real *x, f77_integer CONST_REF incx, f77_real *scale, f77_real *sumsq);
f77_ret_void F77_FUNC(slasv2)(f77_real *f, f77_real *g, f77_real *h__, f77_real *ssmin, f77_real *ssmax, f77_real *snr, f77_real *csr, f77_real *snl, f77_real *csl);
f77_ret_void F77_FUNC(slaswp)(f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *k1, f77_integer *k2, f77_integer *ipiv, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(slasy2)(f77_logical *ltranl, f77_logical *ltranr, f77_integer *isgn, f77_integer *n1, f77_integer *n2, f77_real *tl, f77_integer CONST_REF ldtl, f77_real *tr, f77_integer CONST_REF ldtr, f77_real *b, f77_integer CONST_REF ldb, f77_real *scale, f77_real *x, f77_integer CONST_REF ldx, f77_real *xnorm, f77_integer *info);
f77_ret_void F77_FUNC(slasyf)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(slatbs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(slatdf)(f77_integer *ijob, f77_integer CONST_REF n, f77_real *z__, f77_integer CONST_REF ldz, f77_real *rhs, f77_real *rdsum, f77_real *rdscal, f77_integer *ipiv, f77_integer *jpiv);
f77_ret_void F77_FUNC(slatps)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_real *ap, f77_real *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(slatrd)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_real *a, f77_integer CONST_REF lda, f77_real *e, f77_real *tau, f77_real *w, f77_integer CONST_REF ldw);
f77_ret_void F77_FUNC(slatrs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *x, f77_real *scale, f77_real *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(slatrz)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work);
f77_ret_void F77_FUNC(slatzm)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *v, f77_integer CONST_REF incv, f77_real *tau, f77_real *c1, f77_real *c2, f77_integer CONST_REF ldc, f77_real *work);
f77_ret_void F77_FUNC(slauu2)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(slauum)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(sopgtr)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *tau, f77_real *q, f77_integer CONST_REF ldq, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sopmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *ap, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorg2l)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorg2r)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorgbr)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorghr)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorgl2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorglq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorgql)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorgqr)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorgr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorgrq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorgtr)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorm2l)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sorm2r)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sormbr)(const char *vect, const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormhr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sorml2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sormlq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormql)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormqr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormr2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sormr3)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sormrq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormrz)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(sormtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *c__, f77_integer CONST_REF ldc, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(spbcon)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spbequ)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(spbrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *afb, f77_integer CONST_REF ldafb, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spbstf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(spbsv)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(spbsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *afb, f77_integer CONST_REF ldafb, const char *equed, f77_real *s, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spbtf2)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(spbtrf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(spbtrs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(spocon)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spoequ)(f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(sporfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sposv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sposvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, const char *equed, f77_real *s, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spotf2)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(spotrf)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(spotri)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(spotrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sppcon)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sppequ)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *s, f77_real *scond, f77_real *amax, f77_integer *info);
f77_ret_void F77_FUNC(spprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *afp, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sppsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sppsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *afp, const char *equed, f77_real *s, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(spptrf)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_integer *info);
f77_ret_void F77_FUNC(spptri)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_integer *info);
f77_ret_void F77_FUNC(spptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sptcon)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(spteqr)(const char *compz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sptrfs)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *df, f77_real *ef, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sptsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sptsvx)(const char *fact, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *df, f77_real *ef, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(spttrf)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_integer *info);
f77_ret_void F77_FUNC(spttrs)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sptts2)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *d__, f77_real *e, f77_real *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(srscl)(f77_integer CONST_REF n, f77_real *sa, f77_real *sx, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(ssbev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssbevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ssbevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *q, f77_integer CONST_REF ldq, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssbgst)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_real *ab, f77_integer CONST_REF ldab, f77_real *bb, f77_integer CONST_REF ldbb, f77_real *x, f77_integer CONST_REF ldx, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssbgv)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_real *ab, f77_integer CONST_REF ldab, f77_real *bb, f77_integer CONST_REF ldbb, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssbgvd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_real *ab, f77_integer CONST_REF ldab, f77_real *bb, f77_integer CONST_REF ldbb, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ssbgvx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_real *ab, f77_integer CONST_REF ldab, f77_real *bb, f77_integer CONST_REF ldbb, f77_real *q, f77_integer CONST_REF ldq, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssbtrd)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *d__, f77_real *e, f77_real *q, f77_integer CONST_REF ldq, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sspcon)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sspev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sspevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sspevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(sspgst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *bp, f77_integer *info);
f77_ret_void F77_FUNC(sspgv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *bp, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sspgvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *bp, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sspgvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *bp, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *afp, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sspsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sspsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *afp, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ssptrd)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_real *d__, f77_real *e, f77_real *tau, f77_integer *info);
f77_ret_void F77_FUNC(ssptrf)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(ssptri)(const char *uplo, f77_integer CONST_REF n, f77_real *ap, f77_integer *ipiv, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(sstebz)(const char *range, const char *order, f77_integer CONST_REF n, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_real *d__, f77_real *e, f77_integer *m_out, f77_integer *nsplit, f77_real *w, f77_integer *iblock, f77_integer *isplit, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(sstedc)(const char *compz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sstegr)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sstein)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_integer *m_out, f77_real *w, f77_integer *iblock, f77_integer *isplit, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssteqr)(const char *compz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssterf)(f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_integer *info);
f77_ret_void F77_FUNC(sstev)(const char *jobz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(sstevd)(const char *jobz, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sstevr)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(sstevx)(const char *jobz, const char *range, f77_integer CONST_REF n, f77_real *d__, f77_real *e, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssycon)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *anorm, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ssyev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *w, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ssyevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *w, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ssyevr)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ssyevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssygs2)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ssygst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ssygv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *w, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ssygvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *w, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ssygvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *vl, f77_real *vu, f77_integer *il, f77_integer *iu, f77_real *abstol, f77_integer *m_out, f77_real *w, f77_real *z__, f77_integer CONST_REF ldz, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(ssyrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ssysv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ssysvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *rcond, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ssytd2)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_real *tau, f77_integer *info);
f77_ret_void F77_FUNC(ssytf2)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(ssytrd)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *d__, f77_real *e, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ssytrf)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ssytri)(const char *uplo, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(ssytrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(stbcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_real *ab, f77_integer CONST_REF ldab, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stbrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stbtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_real *ab, f77_integer CONST_REF ldab, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(stgevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(stgex2)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *q, f77_integer CONST_REF ldq, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *j1, f77_integer *n1, f77_integer *n2, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(stgexc)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *q, f77_integer CONST_REF ldq, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *ifst, f77_integer *ilst, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(stgsen)(f77_integer *ijob, f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_logical *select, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *alphar, f77_real *alphai, f77_real *beta, f77_real *q, f77_integer CONST_REF ldq, f77_real *z__, f77_integer CONST_REF ldz, f77_integer *m_out, f77_real *pl, f77_real *pr, f77_real *dif, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(stgsja)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *tola, f77_real *tolb, f77_real *alpha, f77_real *beta, f77_real *u, f77_integer CONST_REF ldu, f77_real *v, f77_integer CONST_REF ldv, f77_real *q, f77_integer CONST_REF ldq, f77_real *work, f77_integer *ncycle, f77_integer *info);
f77_ret_void F77_FUNC(stgsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_real *s, f77_real *dif, f77_integer *mm, f77_integer *m_out, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stgsy2)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *c__, f77_integer CONST_REF ldc, f77_real *d__, f77_integer CONST_REF ldd, f77_real *e, f77_integer CONST_REF lde, f77_real *f, f77_integer CONST_REF ldf, f77_real *scale, f77_real *rdsum, f77_real *rdscal, f77_integer *iwork, f77_integer *pq, f77_integer *info);
f77_ret_void F77_FUNC(stgsyl)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *c__, f77_integer CONST_REF ldc, f77_real *d__, f77_integer CONST_REF ldd, f77_real *e, f77_integer CONST_REF lde, f77_real *f, f77_integer CONST_REF ldf, f77_real *scale, f77_real *dif, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stpcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_real *ap, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stprfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(stptri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_real *ap, f77_integer *info);
f77_ret_void F77_FUNC(stptrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *ap, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(strcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *rcond, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(strevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(strexc)(const char *compq, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *q, f77_integer CONST_REF ldq, f77_integer *ifst, f77_integer *ilst, f77_real *work, f77_integer *info);
f77_ret_void F77_FUNC(strrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *x, f77_integer CONST_REF ldx, f77_real *ferr, f77_real *berr, f77_real *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(strsen)(const char *job, const char *compq, f77_logical *select, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *q, f77_integer CONST_REF ldq, f77_real *wr, f77_real *wi, f77_integer CONST_REF m, f77_real *s, f77_real *sep, f77_real *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(strsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_real *t, f77_integer CONST_REF ldt, f77_real *vl, f77_integer CONST_REF ldvl, f77_real *vr, f77_integer CONST_REF ldvr, f77_real *s, f77_real *sep, f77_integer *mm, f77_integer *m_out, f77_real *work, f77_integer CONST_REF ldwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(strsyl)(const char *trana, const char *tranb, f77_integer *isgn, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_real *c__, f77_integer CONST_REF ldc, f77_real *scale, f77_integer *info);
f77_ret_void F77_FUNC(strti2)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(strtri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(strtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_real *a, f77_integer CONST_REF lda, f77_real *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(stzrqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_integer *info);
f77_ret_void F77_FUNC(stzrzf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_real *a, f77_integer CONST_REF lda, f77_real *tau, f77_real *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(xerbla)(const char *srname, f77_integer *info);
f77_ret_void F77_FUNC(zbdsqr)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF ncvt, f77_integer CONST_REF nru, f77_integer CONST_REF ncc, f77_double *d__, f77_double *e, f77_doublecomplex *vt, f77_integer CONST_REF ldvt, f77_doublecomplex *u, f77_integer CONST_REF ldu, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zdrot)(f77_integer CONST_REF n, f77_doublecomplex *cx, f77_integer CONST_REF incx, f77_doublecomplex *cy, f77_integer CONST_REF incy, f77_double *c__, f77_double *s);
f77_ret_void F77_FUNC(zdrscl)(f77_integer CONST_REF n, f77_double *sa, f77_doublecomplex *sx, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(zgbbrd)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF ncc, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *d__, f77_double *e, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *pt, f77_integer CONST_REF ldpt, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgbcon)(const char *norm, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgbequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(zgbrfs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgbsv)(f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zgbsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *afb, f77_integer CONST_REF ldafb, f77_integer *ipiv, const char *equed, f77_double *r__, f77_double *c__, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgbtf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zgbtrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zgbtrs)(const char *trans, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zgebak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_integer CONST_REF m, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(zgebal)(const char *job, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_integer *info);
f77_ret_void F77_FUNC(zgebd2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_doublecomplex *tauq, f77_doublecomplex *taup, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgebrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_doublecomplex *tauq, f77_doublecomplex *taup, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgecon)(const char *norm, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeequ)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(zgees)(const char *jobvs, const char *sort, f77_logical_func select, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_doublecomplex *w, f77_doublecomplex *vs, f77_integer CONST_REF ldvs, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeesx)(const char *jobvs, const char *sort, f77_logical_func select, const char *sense, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *sdim, f77_doublecomplex *w, f77_doublecomplex *vs, f77_integer CONST_REF ldvs, f77_double *rconde, f77_double *rcondv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *w, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *w, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_double *scale, f77_double *abnrm, f77_double *rconde, f77_double *rcondv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgegs)(const char *jobvsl, const char *jobvsr, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vsl, f77_integer CONST_REF ldvsl, f77_doublecomplex *vsr, f77_integer CONST_REF ldvsr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgegv)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgehd2)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgehrd)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgelq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgelqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgels)(const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgelsx)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_double *rcond, f77_integer *rank, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgelsy)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *jpvt, f77_double *rcond, f77_integer *rank, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeql2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgeqlf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeqp3)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeqpf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_doublecomplex *tau, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgeqr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgeqrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgerfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgerq2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgerqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgesc2)(f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *rhs, f77_integer *ipiv, f77_integer *jpiv, f77_double *scale);
f77_ret_void F77_FUNC(zgesv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zgesvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, const char *equed, f77_double *r__, f77_double *c__, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgetc2)(f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *jpiv, f77_integer *info);
f77_ret_void F77_FUNC(zgetf2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zgetrf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zgetri)(f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgetrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zggbak)(const char *job, const char *side, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_integer CONST_REF m, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_integer *info);
f77_ret_void F77_FUNC(zggbal)(const char *job, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(zgges)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func delctg, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vsl, f77_integer CONST_REF ldvsl, f77_doublecomplex *vsr, f77_integer CONST_REF ldvsr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(zggesx)(const char *jobvsl, const char *jobvsr, const char *sort, f77_logical_func delctg, const char *sense, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *sdim, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vsl, f77_integer CONST_REF ldvsl, f77_doublecomplex *vsr, f77_integer CONST_REF ldvsr, f77_double *rconde, f77_double *rcondv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(zggev)(const char *jobvl, const char *jobvr, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zggevx)(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_integer *ilo, f77_integer *ihi, f77_double *lscale, f77_double *rscale, f77_double *abnrm, f77_double *bbnrm, f77_double *rconde, f77_double *rcondv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *iwork, f77_logical *bwork, f77_integer *info);
f77_ret_void F77_FUNC(zggglm)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *d__, f77_doublecomplex *x, f77_doublecomplex *y, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zgghrd)(const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(zgglse)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_doublecomplex *d__, f77_doublecomplex *x, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zggqrf)(f77_integer CONST_REF n, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *taua, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *taub, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zggrqf)(f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *taua, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *taub, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zggsvd)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF p, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *alpha, f77_double *beta, f77_doublecomplex *u, f77_integer CONST_REF ldu, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(zggsvp)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *tola, f77_double *tolb, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *u, f77_integer CONST_REF ldu, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_integer *iwork, f77_double *rwork, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgtcon)(const char *norm, f77_integer CONST_REF n, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *du2, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zgtrfs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *dlf, f77_doublecomplex *df, f77_doublecomplex *duf, f77_doublecomplex *du2, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgtsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zgtsvx)(const char *fact, const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *dlf, f77_doublecomplex *df, f77_doublecomplex *duf, f77_doublecomplex *du2, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zgttrf)(f77_integer CONST_REF n, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *du2, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zgttrs)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *du2, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zgtts2)(f77_integer *itrans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *du2, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(zhbev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhbevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zhbevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zhbgst)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *bb, f77_integer CONST_REF ldbb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhbgv)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *bb, f77_integer CONST_REF ldbb, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhbgvx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_integer *ka, f77_integer *kb, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *bb, f77_integer CONST_REF ldbb, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zhbtrd)(const char *vect, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *d__, f77_double *e, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zhecon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zheev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *w, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zheevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *w, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zheevr)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zheevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zhegs2)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zhegst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zhegv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *w, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhegvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *w, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zhegvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zherfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhesv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zhesvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhetf2)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zhetrd)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zhetrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zhetri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zhetrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zhgeqz)(const char *job, const char *compq, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpcon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zhpev)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpevd)(const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpevx)(const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zhpgst)(f77_integer *itype, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *bp, f77_integer *info);
f77_ret_void F77_FUNC(zhpgv)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *bp, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpgvd)(f77_integer *itype, const char *jobz, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *bp, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpgvx)(f77_integer *itype, const char *jobz, const char *range, const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *bp, f77_double *vl, f77_double *vu, f77_integer *il, f77_integer *iu, f77_double *abstol, f77_integer *m_out, f77_double *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zhprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhpsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zhpsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zhptrd)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *d__, f77_double *e, f77_doublecomplex *tau, f77_integer *info);
f77_ret_void F77_FUNC(zhptrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zhptri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zhptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zhsein)(const char *side, const char *eigsrc, const char *initv, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *h__, f77_integer CONST_REF ldh, f77_doublecomplex *w, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_doublecomplex *work, f77_double *rwork, f77_integer *ifaill, f77_integer *ifailr, f77_integer *info);
f77_ret_void F77_FUNC(zhseqr)(const char *job, const char *compz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *h__, f77_integer CONST_REF ldh, f77_doublecomplex *w, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zlabrd)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *nb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *d__, f77_double *e, f77_doublecomplex *tauq, f77_doublecomplex *taup, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_doublecomplex *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(zlacgv)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(zlacon)(f77_integer CONST_REF n, f77_doublecomplex *v, f77_doublecomplex *x, f77_double *est, f77_integer *kase);
f77_ret_void F77_FUNC(zlacp2)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(zlacpy)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(zlacrm)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_double *rwork);
f77_ret_void F77_FUNC(zlacrt)(f77_integer CONST_REF n, f77_doublecomplex *cx, f77_integer CONST_REF incx, f77_doublecomplex *cy, f77_integer CONST_REF incy, f77_doublecomplex *c__, f77_doublecomplex *s);
f77_ret_void F77_FUNC(zlaed0)(f77_integer *qsiz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *qstore, f77_integer CONST_REF ldqs, f77_double *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(zlaed7)(f77_integer CONST_REF n, f77_integer *cutpnt, f77_integer *qsiz, f77_integer *tlvls, f77_integer *curlvl, f77_integer *curpbm, f77_double *d__, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_double *rho, f77_integer *indxq, f77_double *qstore, f77_integer *qptr, f77_integer *prmptr, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_double *givnum, f77_doublecomplex *work, f77_double *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(zlaed8)(f77_integer CONST_REF k, f77_integer CONST_REF n, f77_integer *qsiz, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_double *d__, f77_double *rho, f77_integer *cutpnt, f77_double *z__, f77_double *dlamda, f77_doublecomplex *q2, f77_integer CONST_REF ldq2, f77_double *w, f77_integer *indxp, f77_integer *indx, f77_integer *indxq, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_double *givnum, f77_integer *info);
f77_ret_void F77_FUNC(zlaein)(f77_logical *rightv, f77_logical *noinit, f77_integer CONST_REF n, f77_doublecomplex *h__, f77_integer CONST_REF ldh, f77_doublecomplex *w, f77_doublecomplex *v, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *rwork, f77_double *eps3, f77_double *smlnum, f77_integer *info);
f77_ret_void F77_FUNC(zlaesy)(f77_doublecomplex *a, f77_doublecomplex *b, f77_doublecomplex *c__, f77_doublecomplex *rt1, f77_doublecomplex *rt2, f77_doublecomplex *evscal, f77_doublecomplex *cs1, f77_doublecomplex *sn1);
f77_ret_void F77_FUNC(zlaev2)(f77_doublecomplex *a, f77_doublecomplex *b, f77_doublecomplex *c__, f77_double *rt1, f77_double *rt2, f77_double *cs1, f77_doublecomplex *sn1);
f77_ret_void F77_FUNC(zlags2)(f77_logical *upper, f77_double *a1, f77_doublecomplex *a2, f77_double *a3, f77_double *b1, f77_doublecomplex *b2, f77_double *b3, f77_double *csu, f77_doublecomplex *snu, f77_double *csv, f77_doublecomplex *snv, f77_double *csq, f77_doublecomplex *snq);
f77_ret_void F77_FUNC(zlagtm)(const char *trans, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *alpha, f77_doublecomplex *dl, f77_doublecomplex *d__, f77_doublecomplex *du, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *beta, f77_doublecomplex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(zlahef)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(zlahqr)(f77_logical CONST_REF wantt, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *h__, f77_integer CONST_REF ldh, f77_doublecomplex *w, f77_integer *iloz, f77_integer *ihiz, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *info);
f77_ret_void F77_FUNC(zlahrd)(f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *nb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *y, f77_integer CONST_REF ldy);
f77_ret_void F77_FUNC(zlaic1)(f77_integer *job, f77_integer *j, f77_doublecomplex *x, f77_double *sest, f77_doublecomplex *w, f77_doublecomplex *gamma, f77_double *sestpr, f77_doublecomplex *s, f77_doublecomplex *c__);
f77_ret_void F77_FUNC(zlals0)(f77_integer *icompq, f77_integer *nl, f77_integer *nr, f77_integer *sqre, f77_integer CONST_REF nrhs, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *bx, f77_integer CONST_REF ldbx, f77_integer *perm, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_double *givnum, f77_integer CONST_REF ldgnum, f77_double *poles, f77_double *difl, f77_double *difr, f77_double *z__, f77_integer CONST_REF k, f77_double *c__, f77_double *s, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zlalsa)(f77_integer *icompq, f77_integer *smlsiz, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *bx, f77_integer CONST_REF ldbx, f77_double *u, f77_integer CONST_REF ldu, f77_double *vt, f77_integer CONST_REF k, f77_double *difl, f77_double *difr, f77_double *z__, f77_double *poles, f77_integer *givptr, f77_integer *givcol, f77_integer CONST_REF ldgcol, f77_integer *perm, f77_double *givnum, f77_double *c__, f77_double *s, f77_double *rwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(zlapll)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *y, f77_integer CONST_REF incy, f77_double *ssmin);
f77_ret_void F77_FUNC(zlapmt)(f77_logical *forwrd, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_integer CONST_REF k);
f77_ret_void F77_FUNC(zlaqgb)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *kl, f77_integer *ku, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqge)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *r__, f77_double *c__, f77_double *rowcnd, f77_double *colcnd, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqhb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqhe)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqhp)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqp2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_doublecomplex *tau, f77_double *vn1, f77_double *vn2, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlaqps)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *offset, f77_integer *nb, f77_integer *kb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *jpvt, f77_doublecomplex *tau, f77_double *vn1, f77_double *vn2, f77_doublecomplex *auxv, f77_doublecomplex *f, f77_integer CONST_REF ldf);
f77_ret_void F77_FUNC(zlaqsb)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqsp)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlaqsy)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *s, f77_double *scond, f77_double *amax, const char *equed);
f77_ret_void F77_FUNC(zlar1v)(f77_integer CONST_REF n, f77_integer *b1, f77_integer *bn, f77_double *sigma, f77_double *d__, f77_double *l, f77_double *ld, f77_double *lld, f77_double *gersch, f77_doublecomplex *z__, f77_double *ztz, f77_double *mingma, f77_integer *r__, f77_integer *isuppz, f77_double *work);
f77_ret_void F77_FUNC(zlar2v)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_doublecomplex *y, f77_doublecomplex *z__, f77_integer CONST_REF incx, f77_double *c__, f77_doublecomplex *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(zlarcm)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_double *rwork);
f77_ret_void F77_FUNC(zlarf)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *v, f77_integer CONST_REF incv, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlarfb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(zlarfg)(f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *tau);
f77_ret_void F77_FUNC(zlarft)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *tau, f77_doublecomplex *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(zlarfx)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *v, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlargv)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *y, f77_integer CONST_REF incy, f77_double *c__, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(zlarnv)(f77_integer *idist, f77_integer *iseed, f77_integer CONST_REF n, f77_doublecomplex *x);
f77_ret_void F77_FUNC(zlarrv)(f77_integer CONST_REF n, f77_double *d__, f77_double *l, f77_integer *isplit, f77_integer CONST_REF m, f77_double *w, f77_integer *iblock, f77_double *gersch, f77_double *tol, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *isuppz, f77_double *work, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(zlartg)(f77_doublecomplex *f, f77_doublecomplex *g, f77_double *cs, f77_doublecomplex *sn, f77_doublecomplex *r__);
f77_ret_void F77_FUNC(zlartv)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *y, f77_integer CONST_REF incy, f77_double *c__, f77_doublecomplex *s, f77_integer CONST_REF incc);
f77_ret_void F77_FUNC(zlarz)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_doublecomplex *v, f77_integer CONST_REF incv, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlarzb)(const char *side, const char *trans, const char *direct, const char *storev, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF ldwork);
f77_ret_void F77_FUNC(zlarzt)(const char *direct, const char *storev, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *tau, f77_doublecomplex *t, f77_integer CONST_REF ldt);
f77_ret_void F77_FUNC(zlascl)(const char *type__, f77_integer *kl, f77_integer *ku, f77_double *cfrom, f77_double *cto, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zlaset)(const char *uplo, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(zlasr)(const char *side, const char *pivot, const char *direct, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_double *c__, f77_double *s, f77_doublecomplex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(zlassq)(f77_integer CONST_REF n, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_double *scale, f77_double *sumsq);
f77_ret_void F77_FUNC(zlaswp)(f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *k1, f77_integer *k2, f77_integer *ipiv, f77_integer CONST_REF incx);
f77_ret_void F77_FUNC(zlasyf)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_integer *kb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *w, f77_integer CONST_REF ldw, f77_integer *info);
f77_ret_void F77_FUNC(zlatbs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(zlatdf)(f77_integer *ijob, f77_integer CONST_REF n, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *rhs, f77_double *rdsum, f77_double *rdscal, f77_integer *ipiv, f77_integer *jpiv);
f77_ret_void F77_FUNC(zlatps)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(zlatrd)(const char *uplo, f77_integer CONST_REF n, f77_integer *nb, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *e, f77_doublecomplex *tau, f77_doublecomplex *w, f77_integer CONST_REF ldw);
f77_ret_void F77_FUNC(zlatrs)(const char *uplo, const char *trans, const char *diag, const char *normin, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *x, f77_double *scale, f77_double *cnorm, f77_integer *info);
f77_ret_void F77_FUNC(zlatrz)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *l, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlatzm)(const char *side, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *v, f77_integer CONST_REF incv, f77_doublecomplex *tau, f77_doublecomplex *c1, f77_doublecomplex *c2, f77_integer CONST_REF ldc, f77_doublecomplex *work);
f77_ret_void F77_FUNC(zlauu2)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zlauum)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zpbcon)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpbequ)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(zpbrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *afb, f77_integer CONST_REF ldafb, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpbstf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(zpbsv)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zpbsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *afb, f77_integer CONST_REF ldafb, const char *equed, f77_double *s, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpbtf2)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(zpbtrf)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_integer *info);
f77_ret_void F77_FUNC(zpbtrs)(const char *uplo, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zpocon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpoequ)(f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(zporfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zposv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zposvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, const char *equed, f77_double *s, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpotf2)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zpotrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zpotri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(zpotrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zppcon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zppequ)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *s, f77_double *scond, f77_double *amax, f77_integer *info);
f77_ret_void F77_FUNC(zpprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zppsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zppsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, const char *equed, f77_double *s, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpptrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *info);
f77_ret_void F77_FUNC(zpptri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *info);
f77_ret_void F77_FUNC(zpptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zptcon)(f77_integer CONST_REF n, f77_double *d__, f77_doublecomplex *e, f77_double *anorm, f77_double *rcond, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zptrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_doublecomplex *e, f77_double *df, f77_doublecomplex *ef, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zptsv)(f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_doublecomplex *e, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zptsvx)(const char *fact, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_doublecomplex *e, f77_double *df, f77_doublecomplex *ef, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zpttrf)(f77_integer CONST_REF n, f77_double *d__, f77_doublecomplex *e, f77_integer *info);
f77_ret_void F77_FUNC(zpttrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_doublecomplex *e, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zptts2)(f77_integer *iuplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_double *d__, f77_doublecomplex *e, f77_doublecomplex *b, f77_integer CONST_REF ldb);
f77_ret_void F77_FUNC(zrot)(f77_integer CONST_REF n, f77_doublecomplex *cx, f77_integer CONST_REF incx, f77_doublecomplex *cy, f77_integer CONST_REF incy, f77_double *c__, f77_doublecomplex *s);
f77_ret_void F77_FUNC(zspcon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zspmv)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *ap, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *beta, f77_doublecomplex *y, f77_integer CONST_REF incy);
f77_ret_void F77_FUNC(zspr)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *ap);
f77_ret_void F77_FUNC(zsprfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zspsv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zspsvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *afp, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zsptrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zsptri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zsptrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(zstedc)(const char *compz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *lrwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(zstein)(f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_integer CONST_REF m, f77_double *w, f77_integer *iblock, f77_integer *isplit, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *iwork, f77_integer *ifail, f77_integer *info);
f77_ret_void F77_FUNC(zsteqr)(const char *compz, f77_integer CONST_REF n, f77_double *d__, f77_double *e, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_double *work, f77_integer *info);
f77_ret_void F77_FUNC(zsycon)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_double *anorm, f77_double *rcond, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zsymv)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *beta, f77_doublecomplex *y, f77_integer CONST_REF incy);
f77_ret_void F77_FUNC(zsyr)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *alpha, f77_doublecomplex *x, f77_integer CONST_REF incx, f77_doublecomplex *a, f77_integer CONST_REF lda);
f77_ret_void F77_FUNC(zsyrfs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zsysv)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zsysvx)(const char *fact, const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *af, f77_integer CONST_REF ldaf, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *rcond, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(zsytf2)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_integer *info);
f77_ret_void F77_FUNC(zsytrf)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zsytri)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zsytrs)(const char *uplo, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *ipiv, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ztbcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztbrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztbtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer *kd, f77_integer CONST_REF nrhs, f77_doublecomplex *ab, f77_integer CONST_REF ldab, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ztgevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztgex2)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *j1, f77_integer *info);
f77_ret_void F77_FUNC(ztgexc)(f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *ifst, f77_integer *ilst, f77_integer *info);
f77_ret_void F77_FUNC(ztgsen)(f77_integer *ijob, f77_logical CONST_REF wantq, f77_logical CONST_REF wantz, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *alpha, f77_doublecomplex *beta, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *z__, f77_integer CONST_REF ldz, f77_integer *m_out, f77_double *pl, f77_double *pr, f77_double *dif, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer CONST_REF liwork, f77_integer *info);
f77_ret_void F77_FUNC(ztgsja)(const char *jobu, const char *jobv, const char *jobq, f77_integer CONST_REF m, f77_integer CONST_REF p, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_double *tola, f77_double *tolb, f77_double *alpha, f77_double *beta, f77_doublecomplex *u, f77_integer CONST_REF ldu, f77_doublecomplex *v, f77_integer CONST_REF ldv, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *work, f77_integer *ncycle, f77_integer *info);
f77_ret_void F77_FUNC(ztgsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_double *s, f77_double *dif, f77_integer *mm, f77_integer *m_out, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ztgsy2)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *d__, f77_integer CONST_REF ldd, f77_doublecomplex *e, f77_integer CONST_REF lde, f77_doublecomplex *f, f77_integer CONST_REF ldf, f77_double *scale, f77_double *rdsum, f77_double *rdscal, f77_integer *info);
f77_ret_void F77_FUNC(ztgsyl)(const char *trans, f77_integer *ijob, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *d__, f77_integer CONST_REF ldd, f77_doublecomplex *e, f77_integer CONST_REF lde, f77_doublecomplex *f, f77_integer CONST_REF ldf, f77_double *scale, f77_double *dif, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *iwork, f77_integer *info);
f77_ret_void F77_FUNC(ztpcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztprfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztptri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_integer *info);
f77_ret_void F77_FUNC(ztptrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *ap, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ztrcon)(const char *norm, const char *uplo, const char *diag, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_double *rcond, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztrevc)(const char *side, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_integer *mm, f77_integer *m_out, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztrexc)(const char *compq, f77_integer CONST_REF n, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_integer *ifst, f77_integer *ilst, f77_integer *info);
f77_ret_void F77_FUNC(ztrrfs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *x, f77_integer CONST_REF ldx, f77_double *ferr, f77_double *berr, f77_doublecomplex *work, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztrsen)(const char *job, const char *compq, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *w, f77_integer *m_out, f77_double *s, f77_double *sep, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(ztrsna)(const char *job, const char *howmny, f77_logical *select, f77_integer CONST_REF n, f77_doublecomplex *t, f77_integer CONST_REF ldt, f77_doublecomplex *vl, f77_integer CONST_REF ldvl, f77_doublecomplex *vr, f77_integer CONST_REF ldvr, f77_double *s, f77_double *sep, f77_integer *mm, f77_integer *m_out, f77_doublecomplex *work, f77_integer CONST_REF ldwork, f77_double *rwork, f77_integer *info);
f77_ret_void F77_FUNC(ztrsyl)(const char *trana, const char *tranb, f77_integer *isgn, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_double *scale, f77_integer *info);
f77_ret_void F77_FUNC(ztrti2)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(ztrtri)(const char *uplo, const char *diag, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_integer *info);
f77_ret_void F77_FUNC(ztrtrs)(const char *uplo, const char *trans, const char *diag, f77_integer CONST_REF n, f77_integer CONST_REF nrhs, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *b, f77_integer CONST_REF ldb, f77_integer *info);
f77_ret_void F77_FUNC(ztzrqf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_integer *info);
f77_ret_void F77_FUNC(ztzrzf)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zung2l)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zung2r)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zungbr)(const char *vect, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunghr)(f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zungl2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunglq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zungql)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zungqr)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zungr2)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zungrq)(f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zungtr)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunm2l)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunm2r)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunmbr)(const char *vect, const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmhr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer *ilo, f77_integer *ihi, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunml2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunmlq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmql)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmqr)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmr2)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunmr3)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zunmrq)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmrz)(const char *side, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_integer CONST_REF k, f77_integer *l, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zunmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *a, f77_integer CONST_REF lda, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer CONST_REF lwork, f77_integer *info);
f77_ret_void F77_FUNC(zupgtr)(const char *uplo, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *tau, f77_doublecomplex *q, f77_integer CONST_REF ldq, f77_doublecomplex *work, f77_integer *info);
f77_ret_void F77_FUNC(zupmtr)(const char *side, const char *uplo, const char *trans, f77_integer CONST_REF m, f77_integer CONST_REF n, f77_doublecomplex *ap, f77_doublecomplex *tau, f77_doublecomplex *c__, f77_integer CONST_REF ldc, f77_doublecomplex *work, f77_integer *info);

} /* extern "C" */

}
#endif /* CLAPACK_H */
