% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_Xfgpm_Class.R
\name{modelDef}
\alias{modelDef}
\title{Retrieve a \code{fgpm} from within a \code{Xfgpm} object}
\usage{
modelDef(
  object,
  ind,
  trace = TRUE,
  pbars = TRUE,
  control.optim = list(trace = TRUE)
)
}
\arguments{
\item{object}{A \code{Xfgpm} object as created by
\code{\link{fgpm_factory}}.}

\item{ind}{The index (or rank) of the model in \code{object}.}

\item{trace}{An optional boolean indicating whether funGp-native progress
messages should be displayed. Default is TRUE. See the \code{\link[funGp]{fgpm}()}
documentation for more details.}

\item{pbars}{An optional boolean indicating whether progress bars managed by
\code{\link[funGp]{fgpm}()} should be displayed. Default is TRUE. See the
\code{\link[funGp]{fgpm}()} documentation for more details.}

\item{control.optim}{An optional list to be passed as the control argument to
\code{\link[stats]{optim}}(), the function in charge of the non-linear
optimization of the hyperparameters. Default is list(trace = TRUE). See the
\code{\link[funGp]{fgpm}()} documentation for more details.}
}
\value{
A parsed R code defining the \code{fgpm} model.
}
\description{
Retrieve the \code{fgpm} model with index (or rank) \code{i} from
within a \code{Xfgpm} object. By evaluating this code in an
environment containing suitable objects \code{sIn}, \code{fIn} and
\code{sOut} we can re-create a \code{fgpm} object.
}
\details{
The models are sorted by decreasing quality so \code{i = 1} extracts
the definition of the best model.
}
\note{
Remind that the models are sorted by decreasing quality so
    \code{i = 1} extracts the definition of the best model.
}
\examples{
## =========================================================================
## Using the pre-calculated object `xm` to save time. See `?xm` to re-create
## this object.
## =========================================================================

## 'xm@model' is the best 'fgpm' model in 'xm'
plot(xm@model)

## see the R code to use to recreate the model
modelDef(xm, i = 1)

\dontrun{
    ## Define new data in a list. Using an environment would also work,
    ## including the global environment, which is the default in  `eval`.
    L <- list()
    set.seed(341)
    n.new <- 3^5
    x1 <- x2 <- x3 <- x4 <- x5 <- seq(0, 1, length = n.new^(1/5))

    ## create the data objects required to fit the model
    L$sIn <- as.matrix(expand.grid(x1 = x1, x2 = x2, x3 = x3, x4 = x4, x5 = x5))
    L$fIn <- list(f1 = matrix(runif(n.new * 10), ncol = 10),
                   f2 = matrix(runif(n.new * 22), ncol = 22))
    L$sOut <- fgp_BB7(L$sIn, L$fIn, n.new)

    ## Now evaluate
    fgpm.new <- eval(modelDef(xm, i = 1), envir = L)
    plot(fgpm.new, main = "Re-created 'fgpm' model with different data")
    plot(xm[[1]], main = "Re-created 'fgpm' model with the same data")
}
}
\seealso{
The \code{\link{[[,Xfgpm-method}} that can also be used
    to re-create a \code{fgpm} object using \emph{the same data}
    as that used to create the \code{Xfgpm} object in
    \code{object}.
}
