% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{plotPreds-generic}
\alias{plotPreds-generic}
\title{Plot for predictions of regression models}
\arguments{
\item{model}{a model object for which the plot is to be made.}

\item{preds}{data structure containing predictions. Depending on the type of model and the data structure
used, it might also contain, for instance, the confidence bands at the prediction points.}

\item{...}{additional arguments affecting the plot.}
}
\value{
None.
}
\description{
This method displays the predicted output values delivered by some regression model. The
  plot might be constituted differently, depending on the type of model at hand.
}
\examples{
require(funGp) # a package with a plotPreds method implemented
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# making predictions
n.pr <- 100
sIn.pr <- as.matrix(expand.grid(x1 = seq(0,1,length = sqrt(n.pr)),
                                x2 = seq(0,1,length = sqrt(n.pr))))
fIn.pr <- list(f1 = matrix(runif(n.pr*10), ncol = 10), matrix(runif(n.pr*22), ncol = 22))
m1.preds <- predict(m1, sIn.pr = sIn.pr, fIn.pr = fIn.pr)

# plotting predictions
plotPreds(m1, preds = m1.preds)

}
\seealso{
\strong{*} \link[funGp]{plotPreds} for the predictions plot of a funGp model.
}
