% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{plotLOO-generic}
\alias{plotLOO-generic}
\title{Leave-one-out calibration plot for regression models}
\arguments{
\item{model}{a model object for which the LOO calibration plot is to be made.}

\item{...}{additional arguments affecting the plot.}
}
\value{
None.
}
\description{
This method provides a diagnostic plot for the validation of regression models. It displays
  a calibration plot based on the leave-one-out predictions of the output at the points used to train the
  model.
}
\examples{
require(funGp) # a package with a plotLOO method implemented

# generating input and output data for training
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)

# building the model
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# plotting the model
plotLOO(m1)

}
\seealso{
\strong{*} \link[funGp]{plotLOO} for the diagnostic plot of a funGp model.
}
