% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmdplot.R
\name{mmdplot}
\alias{mmdplot}
\title{Plots the trajectory of minimum Mahalanobis distance (mmd)}
\usage{
mmdplot(out, quant = c(0.01, 0.5, 0.99), mplus1 = FALSE, envm, lwd,
  lwdenv, xlim, ylim, tag, datatooltip, label, xlab, ylab, main, nameX,
  cex.lab, cex.axis, databrush, trace = FALSE, ...)
}
\arguments{
\item{out}{An object of S3 class \code{\link{fsmeda.object}} returned by
\code{\link{fsmult}} with \code{monitoring=TRUE} -
a list containing the monitoring of minimum Mahalanobis distance}

\item{quant}{Quantiles for which envelopes have to be computed.
The default is to produce 1\%, 50\% and 99\% envelopes. In other
words the default is \code{quant=c(0.01, 0.5, 0.99)}.}

\item{mplus1}{Wheather to plot the (m+1)-th order statistic.
Specifies if it is necessary to plot the curve associated with
(m+1)-th order statistic.}

\item{envm}{Sample size for drawing enevlopes. Specifies the size of the sample which is
used to superimpose the envelope. The default is to add an envelope based on
all the observations (size \code{n} envelope).}

\item{lwd}{Controls the linewidth of the curve which contains the monitoring
of minimum deletion residual.}

\item{lwdenv}{line width: a scalar which controls the width of the lines associated with the envelopes. Default is \code{lwdenv=1}}

\item{xlim}{Control the x scale in plot. Vector with two elements controlling
minimum and maximum on the x axis. Default is to use automatic scale.}

\item{ylim}{Control the y scale in plot. Vector with two elements controlling
minimum and maximum on the y axis. Default is to use automatic scale.}

\item{tag}{Plot handle. String which identifies the handle of the plot which is about to be created.
The default is \code{tag='pl_mmd'}. Notice that if the program finds a plot which has
a tag equal to the one specified by the user, then the output of the new plot overwrites
the existing one in the same window else a new window is created.}

\item{datatooltip}{If datatooltip is not empty the user can use the mouse in order to have
information about the unit selected, the step in which the unit enters the search and
the associated label. If datatooltip is a list, it is possible to control the aspect
of the data cursor (see MATLAB function \code{datacursormode()} for more details or
see the examples below). The default options are \code{DisplayStyle="Window"} and \code{SnapToDataVertex="on"}.}

\item{label}{Row labels. Character vector containing the labels of the units (optional argument used
when \code{datatooltip=TRUE}. If this field is not present labels
row1, ..., rown will be automatically created and included in the pop up datatooltip window).}

\item{xlab}{A title for the x axis}

\item{ylab}{A title for the y axis}

\item{main}{An overall title for the plot}

\item{nameX}{Add variable labels in the plot. A vector of strings of length \code{p}
containing the labels of the variables of the original data matrix \code{X}.
If it is empty (default) the sequence \code{X1, ..., Xp} will be created automatically}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex}

\item{databrush}{Interactive mouse brushing. If databrush is missing or empty (default), no brushing is done.
 The activation of this option (databrush is TRUE or a list) enables the user to select
   a set of trajectories in the current plot and to see them highlighted in the scatterplot matrix.
   If the scatterplot matrix does not exist it is automatically created.
   In addition, brushed units can be highlighted in the monitoring MD plot. Note that the window
   style of the other figures is set equal to that which contains the monitoring residual plot.
   In other words, if the monitoring residual plot is docked all the other figures will be docked too.

   If \code{databrush=TRUE} the default selection tool is a rectangular brush and it is
   possible to brush only once (that is persist='').

   Note that the window style of the other figures is set equal to that which contains the
   monitoring residual plot. In other words, if the monitoring residual plot is docked all
   the other figures will be docked too

   If \code{databrush=TRUE} the default selection tool is a rectangular brush and
   it is possible to brush only once (that is persist='').

   If \code{databrush=list(...)}, it is possible to use all optional arguments of
   the MATLAB function \code{selectdataFS()} and the following optional arguments:
   \enumerate{
   \item persist. Persist is an empty value or a character containing 'on' or 'off'.
       The default value is \code{persist=""}, that is brushing is allowed only once.
   If \code{persist="on"} or \code{persis="off"} brushing can be done as many time as
   the user requires. If \code{persist='on'} then the unit(s) currently brushed are
   added to those previously brushed. It is possible, every time a new brushing is
   done, to use a different color for the brushed units. If \code{persist='off'}
   every time a new brush is performed units previously brushed are removed.
   }}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
none
}
\description{
Plots the trajectory of minimum Mahalanobis distance (mmd)
}
\examples{

 \dontrun{
 data(hbk)
 (out <- fsmult(hbk[,1:3], monitoring=TRUE))
 mmdplot(out)
 }

}
\references{
Atkinson and Riani (2000), Robust Diagnostic Regression Analysis, Springer Verlag, New York.
}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
