% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{getTrend}
\alias{getTrend}
\title{Temperature trend during a frost night.}
\usage{
getTrend(Tmin, t2, n, plot = FALSE)
}
\arguments{
\item{Tmin}{predicted minimum temperature.}

\item{t2}{temperature 2 hours after sunset, where t2 > Tmin}

\item{n}{how many hours between sunset and sunrise, an integer value where n > 2}

\item{plot}{TRUE if you want to see the trend plot, otherwise FALSE. Default value: FALSE}
}
\value{
A data frame with the (x,y) points plotted, where y values are the n-2 values of estimated temperatures
}
\description{
Predict the trend of the temperature during a frost night.
This equation has been taken
from UC Davis formula [1] which was also published in the FAO book mentioned in predFAO function.

[1] <http://biomet.ucdavis.edu/frostprotection/fp002.htm>
}
\examples{
getTrend(Tmin = 22.2,t2 = 33.7,n = 15) # in °F degress
getTrend(Tmin = -5.45,t2 = 0.95,n = 15,plot=TRUE) # in °C degress
}
