% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dewPoint.R
\name{calcDewPoint.B}
\alias{calcDewPoint.B}
\title{Calculates dew point from ambient temperature and relative humidity.}
\usage{
calcDewPoint.B(RH, temp)
}
\arguments{
\item{RH}{[in percentage] relative humidity, an integer or double value between 0 and 100.}

\item{temp}{[°C] environmental temperature, an integer or double value between -20 and 60 °C}
}
\value{
dew point value (double)
}
\description{
Calculation of dew point using the Mark G. Lawrence approach given in the following paper:
* "The Relationship between Relative Humidity and the Dewpoint Temperature in Moist Air:
A Simple Conversion and Applications", DOI: <https://doi.org/10.1175/BAMS-86-2-225>,
URL: <https://journals.ametsoc.org/doi/pdf/10.1175/BAMS-86-2-225>
}
\examples{
library(frost)
temp <- 25
rh <- 54
calcDewPoint(rh,temp,mode="B")

}
