% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cent_cosums}
\alias{cent_cosums}
\alias{cent_comoments}
\alias{join_cent_cosums}
\alias{unjoin_cent_cosums}
\title{Multivariate centered sums; join and unjoined.}
\usage{
cent_cosums(v, max_order = 2L, na_omit = FALSE)

cent_comoments(v, max_order = 2L, used_df = 0L, na_omit = FALSE)

join_cent_cosums(ret1, ret2)

unjoin_cent_cosums(ret3, ret2)
}
\arguments{
\item{v}{an \eqn{m} by \eqn{n} matrix, each row an independent observation of some
\eqn{n} variate variable.}

\item{max_order}{the maximum order of cosum to compute. For now this can only be
2; in the future higher order cosums should be possible.}

\item{na_omit}{a boolean; if \code{TRUE}, then only rows of \code{v} with complete
observations will be used.}

\item{used_df}{the number of degrees of freedom consumed, used in the denominator
of the centered moments computation. These are subtracted from the number of
observations.}

\item{ret1}{a multdimensional array as output by \code{\link{cent_cosums}}.}

\item{ret2}{a multdimensional array as output by \code{\link{cent_cosums}}.}

\item{ret3}{a multdimensional array as output by \code{\link{cent_cosums}}.}
}
\value{
a multidimensional arry of dimension \code{max_order}, each side of length
\eqn{1+n}. For the case currently implemented where \code{max_order} must be 2, the
output is a symmetric matrix, where the element in the \code{1,1} position is the count of 
complete) rows of \code{v}, the \code{2:(n+1),1} column is the mean, and the
\code{2:(n+1),2:(n+1)} is the co \emph{sums} matrix, which is the covariance up to scaling
by the count. \code{cent_comoments} performs this normalization for you.
}
\description{
Compute, join, or unjoin multivariate centered (co-) sums.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{

 set.seed(1234)
 x1 <- matrix(rnorm(1e3*5,mean=1),ncol=5)
 x2 <- matrix(rnorm(1e3*5,mean=1),ncol=5)
 max_ord <- 2L
 rs1 <- cent_cosums(x1,max_ord)
 rs2 <- cent_cosums(x2,max_ord)
 rs3 <- cent_cosums(rbind(x1,x2),max_ord)
 rs3alt <- join_cent_cosums(rs1,rs2)
 stopifnot(max(abs(rs3 - rs3alt)) < 1e-7)
 rs1alt <- unjoin_cent_cosums(rs3,rs2)
 rs2alt <- unjoin_cent_cosums(rs3,rs1)
 stopifnot(max(abs(rs1 - rs1alt)) < 1e-7)
 stopifnot(max(abs(rs2 - rs2alt)) < 1e-7)

}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}
}
\seealso{
cent_sums
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
