% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/meanfreq.R
\name{statsfreq}
\alias{.corfreq}
\alias{.covfreq}
\alias{.meanfreq}
\alias{.quantilefreq}
\alias{.scalefreq}
\alias{.sdfreq}
\alias{corfreq}
\alias{covfreq}
\alias{meanfreq}
\alias{quantilefreq}
\alias{scalefreq}
\alias{sdfreq}
\alias{statsfreq}
\title{Descriptive statistics of a frequency table.}
\usage{
meanfreq(data, freq = NULL)

.meanfreq(tfq)

quantilefreq(data, probs = c(0, 0.25, 0.5, 0.75, 1), freq = NULL)

.quantilefreq(tfq, probs = c(0, 0.25, 0.5, 0.75, 1))

covfreq(data, freq = NULL)

.covfreq(tfq)

sdfreq(data, freq = NULL)

.sdfreq(tfq)

scalefreq(data, freq = NULL)

.scalefreq(tfq)

corfreq(data, freq = NULL)

.corfreq(tfq)
}
\arguments{
\item{data}{any object that can be processed by \code{link{tablefreq}}.}

\item{freq}{a single name of the variable specifying frequency weights.}

\item{tfq}{a \code{tablefreq} object, or a matrix, data frame with the last column being the frequency wweights}

\item{probs}{A vector of quantiles to compute. Default is 0 (min), .25, .5,
.75, 1 (max).}
}
\value{
\code{meanfreq} and \code{sdfreq} return vectors.
\code{quantilefreq} returns a vector or matrix.
\code{covfreq} and \code{corfreq} the estimated covariance matrix and
correlation matrix, respectively. \code{scalefreq} return a data frame or matrix
}
\description{
Computes the descriptive statistics of a frequency table.
}
\details{
These functions compute various weighted versions of standard estimators.

\code{meanfreq}, \code{sdfreq}, \code{quantilefreq}, \code{covfreq},
\code{corfreq} estimate the mean, standard desviation, quantiles,
covariances and correlation matrix, respectively. In this last two cases,
resulst are equals to the \code{pairwise.complete.obs} option of \code{cov}
and \code{cor} of the desaggregated data, respectively.

Missing values or cases with non-positive frequency weights are
automatically removed.

If \code{freq} is not null, the data set must contain a column with that name. These
variable are removed from the data set in order to calculate the
descriptive statistics.

The dot versions are intented to be used when programing. The \code{tfq} may be a \code{tablefreq} object or a matrix or a data frame with the last column being the frequency weights.

The algorithm of \code{quantilefreq} are based on
\code{\link[Hmisc]{wtd.quantile}}.

The intern functions are for programming purpose. It does not check the data.
}
\note{
The author would like to thank Prof. Frank E. Harrell Jr. who allowed the reutilisation of part of his code.
}
\examples{
if(require(hflights)) {
  meanfreq(hflights[,c("ArrDelay","DepDelay")])
  sdfreq(hflights[,c("ArrDelay","DepDelay")])
  corfreq(hflights[,c("ArrDelay","DepDelay")])
}

tfq <- tablefreq(iris$Sepal.Length)
tfq

meanfreq(iris$Sepal.Length)
meanfreq(tfq,freq="freq")
.meanfreq(tfq)

dat <- iris[,1:4]
quantilefreq(dat)
corfreq(dat)

tfq <- tablefreq(dat)
.meanfreq(tfq)
.quantilefreq(tfq)
.corfreq(tfq)

## dplyr integration
library(dplyr)
tfq  \%>\%
  summarise( mean = .meanfreq(cbind(Sepal.Length,freq)),
            sd = .sdfreq(cbind(Sepal.Length,freq)))

tfq <- tablefreq(iris)
tfq \%>\% group_by(Species) \%>\%
  summarise( mean = .meanfreq(cbind(Sepal.Length,freq)),
            sd = .sdfreq(cbind(Sepal.Length,freq)))
}
\references{
Andrews, Chris,
\url{https://stat.ethz.ch/pipermail/r-help/2014-March/368350.html}
}
\seealso{
\code{\link{tablefreq}}, \code{\link[Hmisc]{wtd.quantile}}
}
\keyword{univar}

