% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nisurface.R
\name{read_nisurface}
\alias{read_nisurface}
\title{Read a surface, based on the file path without extension.}
\usage{
read_nisurface(filepath_noext, extensions = c("", ".asc", ".gii"), ...)
}
\arguments{
\item{filepath_noext}{character string, the full path to the input surface file without file extension.}

\item{extensions}{vector of character strings, the file extensions to try.}

\item{...}{parameters passed on to \code{\link[freesurferformats]{read_nisurfacefile}}. Allows you to set the `methods`.}
}
\value{
an instance of `fs.surface`, read from the file. See \code{\link[freesurferformats]{read.fs.surface}} for details. If none of the reader methods succeed, an error is raised.
}
\description{
Tries to read all files which can be constructed from the base path and the given extensions.
}
\examples{
\dontrun{
    surface_filepath_noext =
     paste(get_optional_data_filepath("subjects_dir/subject1/surf/"),
     'lh.white', sep="");
    mesh = read_nisurface(surface_filepath_noext);
    mesh;
 }

}
\seealso{
Other mesh functions: 
\code{\link{read.fs.surface.asc}()},
\code{\link{read.fs.surface.vtk}()},
\code{\link{read.fs.surface}()},
\code{\link{read_nisurfacefile}()},
\code{\link{write.fs.surface.asc}()},
\code{\link{write.fs.surface.vtk}()},
\code{\link{write.fs.surface}()}
}
\concept{mesh functions}
