% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_vintagedates.R
\name{fredr_series_vintagedates}
\alias{fredr_series_vintagedates}
\title{Get the data vintage dates for a FRED series}
\usage{
fredr_series_vintagedates(
  series_id,
  ...,
  limit = NULL,
  offset = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{series_id}{A string ID for the FRED series.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object where each row is a distinct vintage date.
}
\description{
Given a series ID, return a sequence of dates in history when a series'
data values were revised or new data values were released as a \code{tibble} object.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/series_vintagedates.html}{fred/series/vintagedates}
}

\examples{
if (fredr_has_key()) {
# All data vintages for the "UNRATE" series
fredr_series_vintagedates(series_id = "UNRATE")
# 10 most recent data vintages for the "UNRATE" series
fredr_series_vintagedates(series_id = "UNRATE", limit = 10L, sort_order = "desc")
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_updates]{fredr_series_updates()}}.
}
