% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series_tags.R
\name{fredr_series_tags}
\alias{fredr_series_tags}
\title{Get the tags for a FRED series}
\usage{
fredr_series_tags(
  series_id,
  ...,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{series_id}{A string ID for the FRED series.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{order_by}{A string indicating the attribute by which to order the
Possible values include \code{"series_count"} (default), \code{"popularity"},
\code{"created"}, \code{"name"}, and \code{"group_id"}.}

\item{sort_order}{A string representing the order of the resulting series.
Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \verb{tibble`` object where each row is represents a tag associated with the series specified by }series_id`.  Data include tag name, group ID,
popularity, series count, tag creation date, and additional notes.
}
\description{
Given a series ID, return associated tags for the series as a \code{tibble} object.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/series_tags.html}{fred/series/tags}
}

\examples{
if (fredr_has_key()) {
# Return all tags assigned to the "UNRATE" series and order the results by
# group ID.
fredr_series_tags(series_id = "UNRATE", order_by = "group_id")
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series]{fredr_series()}},
\code{\link[=fredr_series_categories]{fredr_series_categories()}}, \code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
