% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcca.plot.R
\name{dcca.plot}
\alias{dcca.plot}
\title{Detrended Cross Correlation Plot}
\usage{
dcca.plot(
  rhos,
  order = 1,
  ci = FALSE,
  iterations = NULL,
  return.ci = FALSE,
  loess.rho = FALSE,
  loess.ci = FALSE
)
}
\arguments{
\item{rhos}{an object containing  results from detrended cross correlation
analysis. The object should be returned from the \code{dcca} function of this
package.}

\item{order}{integer representing the detrending order used in the dcca 
calculation. Default is 1.}

\item{ci}{a logical indicating whether confidence intervals should be 
computed using the \code{iaafft} function from this package. NOTE: with long 
time series (>> than N = 1,000), this can greatly reduce processing speed. 
Confidence intervals can be used for conventional significance testing of 
scale-wise correlation coefficients.}

\item{iterations}{integer that specifies the the number of surrogate time 
series to be generated for the purpose of confidence intervals. 
Default = 19. Larger number of surrogates will slow computational speed but
produce better confidence interval estimates.}

\item{return.ci}{logical indicating whether the confidence intervals 
should be returned}

\item{loess.rho}{logical indicating whether a loess fit should be used for 
displaying multiscale regression coefficient trajectories}

\item{loess.ci}{logical indicating whether a loess fit should be used to smooth 
confidence intervals}
}
\description{
A plotting method for constructing scalewise correlation plot
}
