% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{FM_fetch_mdl}
\alias{FM_fetch_mdl}
\title{Fetches Models from Modules in the App}
\usage{
FM_fetch_mdl(state, session, ids = NULL)
}
\arguments{
\item{state}{Current module state after yaml file has been read}

\item{session}{Shiny session variable}

\item{ids}{Vector of ID strings for the modules containing models or
NULL for all modules with models available.}
}
\value{
list containing the current dataset with the following format:
\itemize{
   \item{isgood:} General logical indicator of successfully.
   \item{hasmdl:} Logical indicating if at least one model was found.
   \item{modules:} List of module checksums.
   \item{mdl:} Result of MM_fetch_mdl, see  \code{vignette("making_modules", package = "formods")}
  \item{catalog:} Dataframe containing the a tabular catalog of the
  models found.
  \itemize{
    \item{label:}         Text label for the model (e.g. one-compartment model).
    \item{MOD_TYPE:}      Type of module.
    \item{id:}            Module ID.
    \item{rx_obj:}        The rxode2 object.
    \item{rx_obj_name:}   The rxode2 object name that holds the model.
    \item{ts_obj:}        List of timescale information for the system and
                          details of other timescales (\code{list(system="weeks", details = list(days=list(verb="days", conv=86400)))})
    \item{ts_obj_name:}   The object name that holds the timescale for this  model.
    \item{fcn_def:}    Text to define the model.
    \item{MDLMETA:}    Notes about the model.
    \item{code:}       Code to generate the model.
    \item{checksum:}   Module checksum.
    \item{MDLchecksum:} Model checksum.
  }
}
}
\description{
Loops through each specified module ID or all modules if no ID
was specified. For each ID, an attempt will be made to extract any models
available.
}
\examples{
# We need a module state and a Shiny session variable
# to use this function:
id="UD"
sess_res = UD_test_mksession(session=list(), id=id)
session = sess_res$session
state   = sess_res$state
mdl = FM_fetch_mdl(state, session)
mdl$catalog
}
