% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastSNSTS-package.R
\docType{package}
\name{forecastSNSTS-package}
\alias{forecastSNSTS}
\alias{forecastSNSTS-package}
\title{Forecasting of Stationary and Non-Stationary Time Series}
\description{
Methods to compute linear \eqn{h}-step prediction coefficients based on
localised and iterated Yule-Walker estimates and empirical mean square
prediction errors for the resulting predictors.
}
\details{
\tabular{ll}{
   \cr Package: \tab forecastSNSTS
   \cr Type:    \tab Package
   \cr Version: \tab 1.0-0
   \cr Date:    \tab 2016-11-11
   \cr License: \tab GPL (>= 2)
 }
}
\section{Contents}{

The core functionality of this R package is accessable via the function
\code{\link{predCoef}}, which is used to compute the linear prediction
coefficients, and the function \code{\link{MSPE}}, which is used to compute
the empirical mean squared prediciton erros.

The function \code{\link{tvARMA}} can be used to simulate time varying
ARMA(p,q) time series.
}
\author{
Tobias Kley
}
\references{
Kley, T., Preuss, P. & Fryzlewicz, P. (2016).
Predictive, finite-sample model choice for time series under stationarity and non-stationarity.
[cf. \url{personal.lse.ac.uk/kley/forecastSNSTS.pdf}]
}

