% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iif.R
\name{iif_fmp}
\alias{iif_fmp}
\title{FMP Item Information Function}
\usage{
iif_fmp(theta, bmat, cvec = NULL, dvec = NULL)
}
\arguments{
\item{theta}{Vector of latent trait parameters.}

\item{bmat}{Items x parameters matrix of FMP item parameters
(or a vector of FMP item parameters for a single item).}

\item{cvec}{Optional vector of lower asymptote parameters.
If cvec = NULL, then all lower asymptotes set to 0.}

\item{dvec}{Optional vector of upper asymptote parameters.
If dvec = NULL, then all upper asymptotes set to 1.}
}
\value{
Matrix of item information.
}
\description{
Find FMP item information
for user-supplied item and person parameters.
}
\examples{

# plot the IIF for an item with k = 2

set.seed(2342)
bmat <- sim_bmat(n_items = 1, k = 2)$bmat

theta <- seq(-3, 3, by = .01)

information <- iif_fmp(theta = theta, bmat = bmat)

plot(theta, information, type = 'l')

}
