% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{coef.rjMCMC}
\alias{coef.rjMCMC}
\title{Extract Posterior Mean Coefficients from rjMCMC Results}
\usage{
\method{coef}{rjMCMC}(object, ...)
}
\arguments{
\item{object}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, including posterior samples.}

\item{...}{Additional arguments to be passed to other methods or functions.}
}
\value{
A numeric vector containing the posterior mean of the intercept, treatment, and binary parameters.
}
\description{
This function extracts the posterior means of the intercept, treatment parameters,
and binary parameters from the results of an rjMCMC model.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

mcmc_specs <- list(B = 2000, burnin = 1000, thin = 1, chains = 2, sigma_v = 0.1, bma = TRUE)
prior_params <- list(lambda_1 = 0.1, lambda_2 = 1, a_0 = 0.01, b_0 = 0.01,
                  degree = 3, k_max = 9, w = 1, sigma_B = sqrt(20))

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  mcmc_specs, prior_params)
coef(results)
}
}
