% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_albert.R
\docType{data}
\name{drinks}
\alias{drinks}
\title{Dear Mona Followup: Where Do People Drink The Most Beer, Wine And Spirits?}
\format{A data frame with 193 rows representing countries and 5 variables:
\describe{
  \item{country}{country}
  \item{beer_servings}{Servings of beer in average serving sizes per person}
  \item{spirit_servings}{Servings of spirits in average serving sizes per person}
  \item{wine_servings}{Servings of wine in average serving sizes per person}
  \item{total_litres_of_pure_alcohol}{Total litres of pure alcohol per person}
}}
\source{
World Health Organization, Global Information System on Alcohol and Health (GISAH), 2010.
}
\usage{
drinks
}
\description{
The raw data behind the story
"Dear Mona Followup: Where Do People Drink The Most Beer, Wine And Spirits?"
\url{https://fivethirtyeight.com/features/dear-mona-followup-where-do-people-drink-the-most-beer-wine-and-spirits/}.
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
library(stringr)
drinks_tidy <- drinks \%>\%
  gather(type, servings, -c(country, total_litres_of_pure_alcohol)) \%>\%
  mutate(
    type = str_sub(type, start=1, end=-10)
  ) \%>\%
  arrange(country, type)
}
\keyword{datasets}
