% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_starry.R
\docType{data}
\name{house_district_forecast}
\alias{house_district_forecast}
\title{2018 House Forecast}
\format{Because of R package size restrictions, only a preview of the
first 10 rows of this dataset is included; to obtain the entire dataset
see Examples below. The preview is a data frame with 10 rows representing
district-level results of the classic, lite, and deluxe house forecasts
since 2018/08/01 and 11 variables.
\describe{
\item{forecastdate}{date of the forecast}
\item{state}{state of the forecast}
\item{district}{district of the forecast}
\item{candidate}{name of the candidate}
\item{party}{party of the candidate}
\item{incumbent}{whether the candidate is incumbent}
\item{model}{the model of the forecast}
\item{win_probability}{the probability of the corresponding party winning}
\item{voteshare}{the voteshare of the corresponding party}
\item{p10_voteshare}{the top 10 percentile of the voteshare}
\item{p90_voteshare}{the top 00 percentile of the voteshare}
}}
\source{
FiveThirtyEight’s House, Senate And Governor Models
Methodology:
\url{https://fivethirtyeight.com/methodology/how-fivethirtyeights-house-and-senate-models-work/}
}
\usage{
house_district_forecast
}
\description{
The raw data behind the story
'Forecasting the race for the House'
\url{https://projects.fivethirtyeight.com/2018-midterm-election-forecast/house/}
}
\note{
the original dataset included an empty column "special", which was removed.
}
\examples{
if(FALSE){

# To obtain the entire dataset, run the following code:
library(readr)
library(dplyr)
library(janitor)

house_district_forecast <-
  "https://projects.fivethirtyeight.com/congress-model-2018/house_district_forecast.csv" \%>\%
  read_csv() \%>\%
  clean_names() \%>\%
  mutate(
    state = as.factor(state),
    district = as.factor(district),
    party = as.factor(party),
    model = as.factor(model)
  ) \%>\%
  select(-special)

}
}
\seealso{
\code{\link{house_national_forecast}}
}
\keyword{datasets}
