% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffm_function.R
\name{ffm}
\alias{ffm}
\title{Estimate fine fuel moisture}
\usage{
ffm(method, rh, temp, month, hour, asp, slp, bla, shade)
}
\arguments{
\item{method}{a character vector of specifying the method
\code{("pech"}, \code{"simard"}, \code{"wagner"}, \code{"anderson"}, \code{"mcarthur"}, \code{"fbo"})}

\item{rh}{a numeric vector of relative humidities (\%)}

\item{temp}{a numeric vector of dry bulb temperatures (deg. C)}

\item{month}{a numeric vector of Gregorian month numbers (1-12)}

\item{hour}{a numeric vector of hours (1-24)}

\item{asp}{a character vector of aspects specified as cardinal directions, either \code{"N"}, \code{"S"}, \code{"E"}, or \code{"W"}}

\item{slp}{a numeric vector of topographic slopes (\%)}

\item{bla}{a character vector specifying the difference in elevation between the fine fuel's location and that of the meteorological data;
either within 305 m ('l', the default), or the meteorological data are > 305m below (\code{"b"}), or above (\code{"a"}) the fine fuel's location}

\item{shade}{a character vector specifying whether fine fuels are shaded, \code{"y"} or \code{"n"}}
}
\value{
a data frame of litter, 1-hr, 10-hr, and 100-hr fuel moistures
}
\description{
Methods to estimate fine fuel moisture based on meteorological data.
}
\details{
This function has six methods to estimate fine fuel moisture. If \code{method = "fbo"}, all arguments must be specified,
otherwise, only \code{method}, \code{rh} and \code{temp} are required.
}
\examples{
#Example using RAWS meteorological station data
data(rrRAWS)
wx = rrRAWS[2000:3000,]
ff = rbind(
data.frame(ffm = ffm('simard',wx$rh, wx$temp_c)$fm1hr,method='simard'),
data.frame(ffm = ffm('wagner',wx$rh, wx$temp_c)$fm1hr,method='wagner'),
data.frame(ffm = ffm('anderson',wx$rh, wx$temp_c)$fm1hr,method='anderson')
)
ff$dateTime = rep(wx$dateTime,3)
par(mfrow=c(3,1))
hist(ff$ffm[ff$method=="simard"])
hist(ff$ffm[ff$method=="wagner"])
hist(ff$ffm[ff$method=="anderson"])

#The FBO method requires more inputs
rh = wx$rh
temp =wx$temp_c
month = as.numeric(format(strptime(wx$dateTime,"\%m/\%d/\%Y \%H:\%M"),'\%m'))
hour = as.numeric(format(strptime(wx$dateTime,"\%m/\%d/\%Y \%H:\%M"),'\%H'))
ffm(method = 'fbo', rh, temp, month, hour, asp = 'N', slp = 10, bla = 'l', shade = 'n')
}
\references{
Viney, N.R. 1991. A review of fine fuel moisture modelling. \emph{International Journal of Wildland Fire}. \strong{1}(4):215–234.
}
\author{
Justin P Ziegler, \email{justin.ziegler@colostate.edu}
}
