% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_playerscores.R,
%   R/flea_playerscores.R, R/mfl_playerscores.R, R/sleeper_playerscores.R
\name{ff_playerscores}
\alias{ff_playerscores}
\alias{ff_playerscores.espn_conn}
\alias{ff_playerscores.flea_conn}
\alias{ff_playerscores.mfl_conn}
\alias{ff_playerscores.sleeper_conn}
\title{Get Player Scoring History}
\usage{
ff_playerscores(conn, ...)

\method{ff_playerscores}{espn_conn}(conn, limit = 1000, ...)

\method{ff_playerscores}{flea_conn}(conn, page_limit = NULL, ...)

\method{ff_playerscores}{mfl_conn}(conn, season, week, ...)

\method{ff_playerscores}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}

\item{limit}{A numeric describing the number of players to return - default 1000}

\item{page_limit}{A numeric describing the number of pages to return - default NULL returns all available}

\item{season}{the season of interest - generally only the most recent 2-3 seasons are available}

\item{week}{a numeric vector (ie 1:17) or one of YTD (year-to-date) or AVG (average to date)}
}
\value{
A tibble of historical player scoring
}
\description{
This function returns a tidy dataframe of player scores based on league rules.

Unfortunately, Sleeper has deprecated their player stats endpoint from their supported/open API.
Please see \code{ff_scoringhistory()} for an alternative reconstruction.
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns total points for season and average per game, for both current and previous season.

\item \code{flea_conn}: Fleaflicker: returns the season, season average, and standard deviation

\item \code{mfl_conn}: MFL: returns the player fantasy scores for each week (not the actual stats)

\item \code{sleeper_conn}: Sleeper: Deprecated their open API endpoint for player scores
}}

\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird

  conn <- espn_connect(season = 2020, league_id = 899513)

  ff_playerscores(conn, limit = 5)

}) # end try
}
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
conn <- fleaflicker_connect(2020, 312861)
ff_playerscores(conn, page_limit = 2)
}) # end try

}
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
sfb_conn <- mfl_connect(2020, league_id = 65443)
ff_playerscores(conn = sfb_conn, season = 2019, week = "YTD")
}) # end try
}
}
\seealso{
ff_scoringhistory
}
