% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mfl_schedule.R,
%   R/sleeper_schedule.R
\name{ff_schedule}
\alias{ff_schedule}
\alias{ff_schedule.mfl_conn}
\alias{ff_schedule.sleeper_conn}
\title{Get Schedule}
\usage{
ff_schedule(conn, ...)

\method{ff_schedule}{mfl_conn}(conn, ...)

\method{ff_schedule}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{additional args passed to each platform}
}
\value{
A tidy dataframe with one row per game per franchise per week
}
\description{
This function returns a tidy dataframe with one row for every team for every weekly matchup
}
\section{Methods (by class)}{
\itemize{
\item \code{mfl_conn}: MFL: returns schedule data, one row for every franchise for every week. Completed games have result data.

\item \code{sleeper_conn}: Sleeper: returns all schedule data
}}

\examples{
\donttest{
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_schedule(ssb_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = 522458773317046272, season = 2020)
ff_schedule(jml_conn)
}

}
