% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mfl_rosters.R,
%   R/sleeper_rosters.R
\name{ff_rosters}
\alias{ff_rosters}
\alias{ff_rosters.mfl_conn}
\alias{ff_rosters.sleeper_conn}
\title{Get League Rosters}
\usage{
ff_rosters(conn, ...)

\method{ff_rosters}{mfl_conn}(conn, custom_players = FALSE, ...)

\method{ff_rosters}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{arguments passed to other methods (currently none)}

\item{custom_players}{TRUE or FALSE - include custom players? defaults to FALSE}
}
\value{
A tidy dataframe of rosters, joined to basic player information and basic franchise information
}
\description{
This function returns a tidy dataframe of team rosters
}
\section{Methods (by class)}{
\itemize{
\item \code{mfl_conn}: MFL: returns roster data

\item \code{sleeper_conn}: Sleeper: Returns all roster data.
}}

\examples{
\donttest{
ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
ff_rosters(ssb_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = 522458773317046272, season = 2020)
ff_rosters(jml_conn)
}
}
