% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mfl_draftpicks.R,
%   R/sleeper_draftpicks.R
\name{ff_draftpicks}
\alias{ff_draftpicks}
\alias{ff_draftpicks.mfl_conn}
\alias{ff_draftpicks.sleeper_conn}
\title{Get Draft Picks}
\usage{
ff_draftpicks(conn, ...)

\method{ff_draftpicks}{mfl_conn}(conn, ...)

\method{ff_draftpicks}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}
}
\value{
Returns a dataframe with current and future draft picks for each franchise
}
\description{
Returns all draft picks (current and future) that belong to a specific franchise and have not yet been converted into players (i.e. selected.)
}
\section{Methods (by class)}{
\itemize{
\item \code{mfl_conn}: MFL: returns current and future picks

\item \code{sleeper_conn}: Sleeper: retrieves current and future draft picks
}}

\examples{
\donttest{
dlf_conn <- mfl_connect(2020, league_id = 37920)
ff_draftpicks(conn = dlf_conn)
}

\donttest{
jml_conn <- ff_connect(platform = "sleeper", league_id = 522458773317046272, season = 2020)
ff_draftpicks(jml_conn)
}

}
