% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fregre.gls.r
\name{predict.fregre.gls}
\alias{predict.fregre.gls}
\alias{predict.fregre.igls}
\title{Predictions from a functional gls object}
\usage{
\method{predict}{fregre.gls}(
  object,
  newx = NULL,
  type = "response",
  se.fit = FALSE,
  scale = NULL,
  df,
  interval = "none",
  ...
)

\method{predict}{fregre.igls}(
  object,
  newx = NULL,
  data,
  df = df,
  weights = 1,
  pred.var,
  n.ahead = 1L,
  ...
)
}
\arguments{
\item{object}{\code{fregre.gls} object.}

\item{newx}{An optional data list in which to look for
variables with which to predict. If omitted, the fitted values are used.
List of new explanatory data.}

\item{type}{Type of prediction (response or model term).}

\item{se.fit}{=TRUE (not default) standard error estimates are returned for
each prediction.}

\item{scale}{Scale parameter for std.err. calculation.}

\item{df}{Degrees of freedom for scale.}

\item{interval}{Type of interval calculation.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{data}{Data frame with the time or spatinal index}

\item{weights}{variance weights for prediction. This can be a numeric vector
or a one-sided model formula. In the latter case, it is interpreted as an
expression evaluated in newdata}

\item{pred.var}{the variance(s) for future observations to be assumed for
prediction intervals. See \code{link{predict.lm}} for more details.}

\item{n.ahead}{number of steps ahead at which to predict.}
}
\value{
a vector with the predicted values.
}
\description{
The predictions for the functional generalized least squares fitted linear
model represented by \code{object} are obtained at the covariate values
defined in \code{newx}.
}
\examples{
\dontrun{
data(tecator)
ind<-1:190
x <-fdata.deriv(tecator$absorp.fdata,nderiv=1)
dataf=as.data.frame(tecator$y)
dataf$itime <- 1:nrow(x)
ldat=list("df"=dataf[ind,],"x"=x[ind])
newldat=list("df"=dataf[-ind,],"x"=x[-ind])
newy <- tecator$y$Fat[-ind]
ff <- Fat ~ x
res.lm <- fregre.lm(ff,data=ldat)
summary(res.lm)
res.gls <- fregre.gls(ff,data=ldat, correlation=corAR1())
summary(res.gls)
par.cor <- list("cor.ARMA"=list("p"=1))
par.cor <- list("cor.ARMA"=list("index"=c("itime"),"p"=1))
res.igls <- fregre.igls(ff,data=ldat,correlation=par.cor) 
pred.lm <- predict(res.lm,newldat)
pred.gls <- predict(res.gls,newldat)
pred.igls <- predict(res.igls,newldat)
mean((pred.lm-newldat$df$Fat)^2)
mean((pred.gls-newldat$df$Fat)^2)
mean((pred.igls-newldat$df$Fat)^2)
}

}
\references{
Oviedo de la Fuente, M., Febrero-Bande, M., Pilar Munoz, and
Dominguez, A. Predicting seasonal influenza transmission using Functional
Regression Models with Temporal Dependence. arXiv:1610.08718.
\url{https://arxiv.org/abs/1610.08718}
}
\seealso{
\code{\link{fregre.gls}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{models}
\keyword{regresion}
