\name{fcrosTopN}
\alias{fcrosTopN}

\title{fcrosTopN: Search for the "top N" differentially expressed genes}

\description{This function allows to seach for the "top N" DE genes.
It uses the f-values obtained using fcros() or fcros2().}

\usage{fcrosTopN(fvalue, topN)}

\arguments{
  \item{fvalue}{ This is a f-value vector obtained using functions fcros() or fcros2(): 
                 \code{fvalue}}
  \item{topN}{ Expected number of DE genes in the data used: \code{topN}}
}

\value{ This function returns a data frame containing 2 components
    \item{alpha }{Two threshold values allowing to have "top N" DE genes}
    \item{index }{Indexes of the "top N" DE genes}
}

\author{Doulaye Dembele doulaye@igbmc.fr}

\references{Dembele D and Kastner P, Fold change ranks ordering statistics for detecting
                    differentially expressed genes, 2013, Manuscript submitted}

\examples{
   data(fdata);

   cont <- c("cont01", "cont07", "cont03", "cont04", "cont08");
   test <- c("test01", "test02", "test08", "test09", "test05");
   log2.opt <- 0;

   # perform fcros
   af <- fcros(fdata, cont, test, log2.opt);
   
   # now select top 10 down and/or up regulated genes
   top10 <- fcrosTopN(af$f.value,10);

   # display thresholds
   top10$alpha
   
   # display index of top10 genes
   fdata[top10$index,1]
   
   # display fvalue of the top10 genes
   (af$f.value)[top10$index]
}
