% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.degree.entropy.R
\name{metric.degree.entropy}
\alias{metric.degree.entropy}
\title{Degree Entropy}
\usage{
metric.degree.entropy(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the degree entropy of a graph.
}
\details{
Calculates the degree entropy of graph g, i.e. \deqn{Entropy(g) = - \sum_{i=1}^{n} i*\log _2(i)}
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.degree.entropy(x)}
}
\references{
Anand, Kartik, and Ginestra Bianconi. "Entropy measures for networks: Toward an information theory of complex topologies." Physical Review E 80, no. 4 (2009): 045102.
}
\author{
Xu Dong, Nazrul Shaikh.
}
