% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.R
\name{has_ctl}
\alias{has_ctl}
\alias{has_sgr}
\title{Checks for Presence of Control Sequences}
\usage{
has_ctl(x, which = "all", warn = getOption("fansi.warn"))

has_sgr(x, warn = getOption("fansi.warn"))
}
\arguments{
\item{x}{a character vector or object that can be coerced to character.}

\item{which}{character, what \emph{Control Sequences} to check for; see \code{strip}
parameter for \link{strip_ctl} for details.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \link{fansi}).}
}
\value{
logical of same length as \code{x}; NA values in \code{x} result in NA values
in return
}
\description{
\code{has_ctl} checks for any \emph{Control Sequence}, whereas \code{has_sgr} checks only
for ANSI CSI SGR sequences.  You can check for different types of sequences
with the \code{which} parameter.
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
