% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{covmat.fsvdraws}
\alias{covmat.fsvdraws}
\title{Extract posterior draws of the model-implied covariance matrix}
\usage{
\method{covmat}{fsvdraws}(x, timepoints = "all", ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
of \code{\link{fsvsample}}.}

\item{timepoints}{Vector indicating at which point(s) in time (of those that
have been stored during sampling) the correlation matrices should be
extracted. Can also be "all" or "last".}

\item{...}{Ignored.}
}
\value{
Array of dimension \code{m} times \code{m} times \code{draws}
times \code{timepoints} containing the posterior draws for the
model-implied covariance matrix.
}
\description{
\code{covmat} extracts draws from the model-implied covariance matrix
from an \code{fsvdraws} object for all points in time which have been
stored.
}
\note{
Currently crudely implemented as a double loop in pure R,
may be slow.
}
\examples{
\donttest{
set.seed(1)
sim <- fsvsim(n = 500, series = 3, factors = 1) # simulate
res <- fsvsample(sim$y, factors = 1, keeptime = "all") # estimate
covs <- covmat(res, "last") # extract

# Trace plot of determinant of posterior covariance matrix
# at time t = n = 500:
detdraws <- apply(covs[,,,1], 3, det)
ts.plot(detdraws)
abline(h = mean(detdraws), col = 2)          # posterior mean
abline(h = median(detdraws), col = 4)        # posterior median
abline(h = det(covmat(sim, "last")[,,1]), col = 3) # implied by DGP

# Trace plot of draws from posterior covariance of Sim1 and Sim2 at
# time t = n = 500:
ts.plot(covs[1,2,,1])
abline(h = covmat(sim, "last")[1,2,1], col = 3) # "true" value

# Smoothed kernel density estimate:
plot(density(covs[1,2,,1], adjust = 2))

# Summary statistics:
summary(covs[1,2,,1])
}

}
\seealso{
Other extractors: 
\code{\link{cormat.fsvdraws}()},
\code{\link{runningcormat}()},
\code{\link{runningcovmat}()}
}
\concept{extractors}
